/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.regression;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.data.DatasetUtil;
import gov.sandia.cognition.learning.data.DefaultWeightedInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.data.WeightedInputOutputPair;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.ArrayList;
import java.util.Collection;

@PublicationReference(author={"Andrew W. Moore"}, title="Instance-based learning (aka Case-based or Memory-based or non-parametric)", type=PublicationType.WebPage, year=2006, url="http://www.autonlab.org/tutorials/mbl.html")
public class LocallyWeightedFunction<InputType, OutputType>
implements Evaluator<InputType, OutputType> {
    private Kernel<? super InputType> kernel;
    private SupervisedBatchLearner<InputType, OutputType, ?> learner;
    private ArrayList<WeightedInputOutputPair<InputType, OutputType>> rawData;
    private ArrayList<DefaultWeightedInputOutputPair<InputType, OutputType>> locallyWeightedData;
    private Evaluator<? super InputType, ? extends OutputType> localApproximator;

    public LocallyWeightedFunction(Kernel<? super InputType> kernel, Collection<? extends InputOutputPair<? extends InputType, OutputType>> rawData, SupervisedBatchLearner<InputType, OutputType, ?> learner) {
        this.setKernel(kernel);
        ArrayList<DefaultWeightedInputOutputPair<InputType, OutputType>> weightedRawData = new ArrayList<DefaultWeightedInputOutputPair<InputType, OutputType>>(rawData.size());
        this.locallyWeightedData = new ArrayList(rawData.size());
        for (InputOutputPair<InputType, OutputType> inputOutputPair : rawData) {
            double weight = DatasetUtil.getWeight(inputOutputPair);
            weightedRawData.add(new DefaultWeightedInputOutputPair<InputType, OutputType>(inputOutputPair, weight));
            this.locallyWeightedData.add(new DefaultWeightedInputOutputPair<InputType, OutputType>(inputOutputPair, weight));
        }
        this.rawData = weightedRawData;
        this.setLearner(learner);
        this.setLocalApproximator(null);
    }

    public Kernel<? super InputType> getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel<? super InputType> kernel) {
        this.kernel = kernel;
    }

    public SupervisedBatchLearner<InputType, OutputType, ?> getLearner() {
        return this.learner;
    }

    public void setLearner(SupervisedBatchLearner<InputType, OutputType, ?> learner) {
        this.learner = learner;
    }

    @Override
    public OutputType evaluate(InputType input) {
        for (int i = 0; i < this.rawData.size(); ++i) {
            WeightedInputOutputPair<InputType, OutputType> originalPair = this.rawData.get(i);
            DefaultWeightedInputOutputPair<InputType, OutputType> locallyWeightedPair = this.locallyWeightedData.get(i);
            double kernelWeight = this.kernel.evaluate(input, originalPair.getInput());
            double originalWeight = originalPair.getWeight();
            double localWeight = kernelWeight * originalWeight;
            locallyWeightedPair.setWeight(localWeight);
        }
        this.localApproximator = (Evaluator)this.learner.learn(this.locallyWeightedData);
        return this.localApproximator.evaluate(input);
    }

    public Evaluator<? super InputType, ? extends OutputType> getLocalApproximator() {
        return this.localApproximator;
    }

    public void setLocalApproximator(Evaluator<? super InputType, ? extends OutputType> localApproximator) {
        this.localApproximator = localApproximator;
    }

    public static class Learner<InputType, OutputType>
    extends AbstractCloneableSerializable
    implements SupervisedBatchLearner<InputType, OutputType, LocallyWeightedFunction<? super InputType, OutputType>> {
        private Kernel<? super InputType> kernel;
        private SupervisedBatchLearner<InputType, OutputType, ?> learner;

        public Learner(Kernel<? super InputType> kernel, SupervisedBatchLearner<InputType, OutputType, ?> learner) {
            this.setKernel(kernel);
            this.setLearner(learner);
        }

        @Override
        public LocallyWeightedFunction<InputType, OutputType> learn(Collection<? extends InputOutputPair<? extends InputType, OutputType>> data) {
            return new LocallyWeightedFunction<InputType, OutputType>(this.getKernel(), data, this.getLearner());
        }

        public Kernel<? super InputType> getKernel() {
            return this.kernel;
        }

        public void setKernel(Kernel<? super InputType> kernel) {
            this.kernel = kernel;
        }

        public SupervisedBatchLearner<InputType, OutputType, ?> getLearner() {
            return this.learner;
        }

        public void setLearner(SupervisedBatchLearner<InputType, OutputType, ?> learner) {
            this.learner = learner;
        }
    }
}

