/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.regression;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.FunctionMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.FunctionMinimizerDirectionSetPowell;
import gov.sandia.cognition.learning.algorithm.regression.AbstractMinimizerBasedParameterCostMinimizer;
import gov.sandia.cognition.learning.function.cost.SupervisedCostFunction;
import gov.sandia.cognition.math.DifferentiableEvaluator;
import gov.sandia.cognition.math.matrix.NumericalDifferentiator;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorizableVectorFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

public class ParameterDerivativeFreeCostMinimizer
extends AbstractMinimizerBasedParameterCostMinimizer<VectorizableVectorFunction, DifferentiableEvaluator<Vector, Double, Vector>> {
    public static final FunctionMinimizer<Vector, Double, Evaluator<? super Vector, Double>> DEFAULT_FUNCTION_MINIMIZER = new FunctionMinimizerDirectionSetPowell();

    public ParameterDerivativeFreeCostMinimizer() {
        this((FunctionMinimizer<Vector, Double, ? super DifferentiableEvaluator<Vector, Double, Vector>>)ObjectUtil.cloneSafe(DEFAULT_FUNCTION_MINIMIZER));
    }

    public ParameterDerivativeFreeCostMinimizer(FunctionMinimizer<Vector, Double, ? super DifferentiableEvaluator<Vector, Double, Vector>> minimizer) {
        super(minimizer);
    }

    @Override
    public ParameterDerivativeFreeCostMinimizer clone() {
        return (ParameterDerivativeFreeCostMinimizer)super.clone();
    }

    @Override
    public ParameterCostEvaluatorDerivativeFree createInternalFunction() {
        return new ParameterCostEvaluatorDerivativeFree((VectorizableVectorFunction)this.getResult(), (SupervisedCostFunction<Vector, Vector>)this.getCostFunction());
    }

    public static class ParameterCostEvaluatorDerivativeFree
    extends AbstractCloneableSerializable
    implements DifferentiableEvaluator<Vector, Double, Vector> {
        private VectorizableVectorFunction internalFunction;
        private SupervisedCostFunction<Vector, Vector> costFunction;

        public ParameterCostEvaluatorDerivativeFree(VectorizableVectorFunction internalFunction, SupervisedCostFunction<Vector, Vector> costFunction) {
            this.internalFunction = internalFunction;
            this.costFunction = costFunction;
        }

        @Override
        public Vector differentiate(Vector input) {
            return NumericalDifferentiator.VectorJacobian.differentiate(input, this);
        }

        @Override
        public Double evaluate(Vector input) {
            this.internalFunction.convertFromVector(input);
            return this.costFunction.evaluate(this.internalFunction);
        }

        @Override
        public ParameterCostEvaluatorDerivativeFree clone() {
            ParameterCostEvaluatorDerivativeFree clone = (ParameterCostEvaluatorDerivativeFree)super.clone();
            clone.costFunction = ObjectUtil.cloneSafe(this.costFunction);
            clone.internalFunction = ObjectUtil.cloneSafe(this.internalFunction);
            return clone;
        }
    }
}

