/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.regression;

import gov.sandia.cognition.learning.algorithm.gradient.GradientDescendable;
import gov.sandia.cognition.learning.algorithm.minimization.FunctionMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.FunctionMinimizerBFGS;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizerBacktracking;
import gov.sandia.cognition.learning.algorithm.regression.AbstractMinimizerBasedParameterCostMinimizer;
import gov.sandia.cognition.learning.function.cost.DifferentiableCostFunction;
import gov.sandia.cognition.math.DifferentiableEvaluator;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

public class ParameterDifferentiableCostMinimizer
extends AbstractMinimizerBasedParameterCostMinimizer<GradientDescendable, DifferentiableEvaluator<Vector, Double, Vector>> {
    public static final FunctionMinimizer<Vector, Double, DifferentiableEvaluator<? super Vector, Double, Vector>> DEFAULT_FUNCTION_MINIMIZER = new FunctionMinimizerBFGS(new LineMinimizerBacktracking());

    public ParameterDifferentiableCostMinimizer() {
        this((FunctionMinimizer<Vector, Double, ? super DifferentiableEvaluator<Vector, Double, Vector>>)ObjectUtil.cloneSafe(DEFAULT_FUNCTION_MINIMIZER));
    }

    public ParameterDifferentiableCostMinimizer(FunctionMinimizer<Vector, Double, ? super DifferentiableEvaluator<Vector, Double, Vector>> minimizer) {
        super(minimizer);
    }

    @Override
    public ParameterDifferentiableCostMinimizer clone() {
        return (ParameterDifferentiableCostMinimizer)super.clone();
    }

    @Override
    public ParameterCostEvaluatorDerivativeBased createInternalFunction() {
        return new ParameterCostEvaluatorDerivativeBased((GradientDescendable)this.getResult(), (DifferentiableCostFunction)this.getCostFunction());
    }

    public static class ParameterCostEvaluatorDerivativeBased
    extends AbstractCloneableSerializable
    implements DifferentiableEvaluator<Vector, Double, Vector> {
        private GradientDescendable internalFunction;
        private DifferentiableCostFunction costFunction;

        public ParameterCostEvaluatorDerivativeBased(GradientDescendable internalFunction, DifferentiableCostFunction costFunction) {
            this.internalFunction = internalFunction;
            this.costFunction = costFunction;
        }

        @Override
        public Vector differentiate(Vector input) {
            this.internalFunction.convertFromVector(input);
            return this.costFunction.computeParameterGradient(this.internalFunction);
        }

        @Override
        public Double evaluate(Vector input) {
            this.internalFunction.convertFromVector(input);
            return this.costFunction.evaluate(this.internalFunction);
        }

        @Override
        public ParameterCostEvaluatorDerivativeBased clone() {
            ParameterCostEvaluatorDerivativeBased clone = (ParameterCostEvaluatorDerivativeBased)super.clone();
            clone.costFunction = ObjectUtil.cloneSafe(this.costFunction);
            clone.internalFunction = ObjectUtil.cloneSafe(this.internalFunction);
            return clone;
        }
    }
}

