/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.root;

import gov.sandia.cognition.learning.algorithm.minimization.line.LineBracket;
import gov.sandia.cognition.learning.algorithm.root.AbstractRootFinder;
import gov.sandia.cognition.learning.algorithm.root.RootBracketExpander;
import gov.sandia.cognition.learning.algorithm.root.RootBracketer;
import gov.sandia.cognition.learning.data.InputOutputPair;

public abstract class AbstractBracketedRootFinder
extends AbstractRootFinder {
    public static final RootBracketer DEFAULT_ROOT_BRACKETER = new RootBracketExpander();
    private RootBracketer bracketer;
    private LineBracket rootBracket;

    public AbstractBracketedRootFinder() {
        this.setBracketer(DEFAULT_ROOT_BRACKETER);
        this.setRootBracket(null);
    }

    @Override
    protected boolean initializeAlgorithm() {
        this.getBracketer().setInitialGuess(this.getInitialGuess());
        this.setRootBracket((LineBracket)this.getBracketer().learn(this.data));
        return this.getBracketer().isResultValid();
    }

    @Override
    protected void cleanupAlgorithm() {
    }

    @Override
    public InputOutputPair<Double, Double> getResult() {
        return this.getRootBracket() != null ? this.getRootBracket().getOtherPoint() : null;
    }

    public RootBracketer getBracketer() {
        return this.bracketer;
    }

    public void setBracketer(RootBracketer bracketer) {
        this.bracketer = bracketer;
    }

    public LineBracket getRootBracket() {
        return this.rootBracket;
    }

    public void setRootBracket(LineBracket rootBracket) {
        this.rootBracket = rootBracket;
    }
}

