/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.root;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.AbstractAnytimeBatchLearner;
import gov.sandia.cognition.learning.algorithm.minimization.line.InputOutputSlopeTriplet;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineBracket;
import gov.sandia.cognition.learning.algorithm.root.RootBracketer;

public class RootBracketExpander
extends AbstractAnytimeBatchLearner<Evaluator<Double, Double>, LineBracket>
implements RootBracketer {
    public static final double SCALE_FACTOR = 1.618034;
    public static final int DEFAULT_MAX_ITERATIONS = 100;
    public static final double DEFAULT_INITIAL_GUESS = 0.0;
    private LineBracket bracket;
    private double initialGuess;

    public RootBracketExpander() {
        super(100);
        this.setInitialGuess(0.0);
        this.setBracket(null);
    }

    @Override
    protected boolean initializeAlgorithm() {
        Evaluator f = (Evaluator)this.data;
        double x0 = this.getInitialGuess();
        Double y0 = (Double)f.evaluate(x0);
        InputOutputSlopeTriplet initial = new InputOutputSlopeTriplet(x0, y0, null);
        double x1 = x0 + 1.618034;
        Double y1 = (Double)f.evaluate(x1);
        InputOutputSlopeTriplet guess = new InputOutputSlopeTriplet(x1, y1, null);
        this.setBracket(new LineBracket(initial, guess, initial.clone()));
        return true;
    }

    @Override
    protected boolean step() {
        double x0 = (Double)this.getBracket().getLowerBound().getInput();
        double y0 = (Double)this.getBracket().getLowerBound().getOutput();
        double x1 = (Double)this.getBracket().getUpperBound().getInput();
        double y1 = (Double)this.getBracket().getUpperBound().getOutput();
        if (y0 * y1 < 0.0) {
            return false;
        }
        if (Math.abs(y0) < Math.abs(y1)) {
            x0 += 1.618034 * (x0 - x1);
            y0 = (Double)((Evaluator)this.data).evaluate(x0);
            this.getBracket().getLowerBound().setInput(x0);
            this.getBracket().getLowerBound().setOutput(y0);
        } else {
            x1 += 1.618034 * (x1 - x0);
            y1 = (Double)((Evaluator)this.data).evaluate(x1);
            this.getBracket().getUpperBound().setInput(x1);
            this.getBracket().getUpperBound().setOutput(y1);
        }
        return y0 * y1 > 0.0;
    }

    @Override
    protected void cleanupAlgorithm() {
        InputOutputSlopeTriplet a = this.getBracket().getLowerBound();
        InputOutputSlopeTriplet b = this.getBracket().getUpperBound();
        if ((Double)a.getInput() > (Double)b.getInput()) {
            this.getBracket().setLowerBound(b);
            this.getBracket().setUpperBound(a);
        }
    }

    @Override
    public LineBracket getResult() {
        return this.getBracket();
    }

    @Override
    public boolean isResultValid() {
        return super.isResultValid() && (Double)this.getBracket().getLowerBound().getOutput() * (Double)this.getBracket().getUpperBound().getOutput() < 0.0;
    }

    public double getInitialGuess() {
        return this.initialGuess;
    }

    @Override
    public void setInitialGuess(double initialGuess) {
        this.initialGuess = initialGuess;
    }

    public LineBracket getBracket() {
        return this.bracket;
    }

    protected void setBracket(LineBracket bracket) {
        this.bracket = bracket;
    }
}

