/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.root;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.root.AbstractRootFinder;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.math.DifferentiableEvaluator;
import gov.sandia.cognition.math.matrix.NumericalDifferentiator;
import gov.sandia.cognition.util.ObjectUtil;

@PublicationReference(author={"Wikipedia"}, title="Newton's Method", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/Newton%27s_method")
public class RootFinderNewtonsMethod
extends AbstractRootFinder {
    public DefaultInputOutputPair<Double, Double> result;
    private DifferentiableEvaluator<Double, Double, Double> dfdx;
    private double stepMultiplier;
    private static final double STEP_SCALE = 0.5;

    @Override
    public RootFinderNewtonsMethod clone() {
        RootFinderNewtonsMethod clone = (RootFinderNewtonsMethod)super.clone();
        clone.result = (DefaultInputOutputPair)ObjectUtil.cloneSafe(this.getResult());
        return clone;
    }

    @Override
    protected boolean initializeAlgorithm() {
        double x = this.getInitialGuess();
        double fx = (Double)((Evaluator)this.data).evaluate(x);
        this.dfdx = this.data instanceof DifferentiableEvaluator ? (DifferentiableEvaluator)this.data : new NumericalDifferentiator.DoubleJacobian((Evaluator)this.data, this.getTolerance());
        this.stepMultiplier = 1.0;
        this.result = new DefaultInputOutputPair<Double, Double>(x, fx);
        return true;
    }

    @Override
    protected boolean step() {
        double xhat;
        double step;
        double x = this.result.getInput();
        double fx = this.result.getOutput();
        double slope = this.dfdx.differentiate(x);
        if (Math.abs(slope) >= Double.MIN_VALUE) {
            step = this.stepMultiplier * -fx / slope;
            xhat = x + step;
        } else {
            step = this.stepMultiplier * -fx;
            xhat = x + step;
        }
        double fxhat = (Double)((Evaluator)this.data).evaluate(xhat);
        if (Math.abs(fxhat) < Math.abs(fx)) {
            this.stepMultiplier = 1.0;
            this.result.setInput(xhat);
            this.result.setOutput(fxhat);
        } else {
            this.stepMultiplier *= 0.5;
        }
        return Math.abs(this.result.getOutput()) > this.getTolerance();
    }

    @Override
    protected void cleanupAlgorithm() {
    }

    @Override
    public DefaultInputOutputPair<Double, Double> getResult() {
        return this.result;
    }
}

