/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.root;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.line.InputOutputSlopeTriplet;
import gov.sandia.cognition.learning.algorithm.root.AbstractBracketedRootFinder;

@PublicationReference(author={"Wikipedia"}, title="Ridders' Method", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Ridders%27_method")
public class RootFinderRiddersMethod
extends AbstractBracketedRootFinder {
    @Override
    protected boolean step() {
        double x1 = (Double)this.getRootBracket().getLowerBound().getInput();
        double f1 = (Double)this.getRootBracket().getLowerBound().getOutput();
        double x2 = (Double)this.getRootBracket().getUpperBound().getInput();
        double f2 = (Double)this.getRootBracket().getUpperBound().getOutput();
        double xmid = 0.5 * (x1 + x2);
        double fmid = (Double)((Evaluator)this.data).evaluate(xmid);
        InputOutputSlopeTriplet midpoint = new InputOutputSlopeTriplet(xmid, fmid, null);
        double t1 = Math.sqrt(fmid * fmid - f1 * f2);
        if (t1 == 0.0) {
            return false;
        }
        double xnew = xmid + (xmid - x1) * Math.signum(f1 - f2) * fmid / t1;
        double fnew = (Double)((Evaluator)this.data).evaluate(xnew);
        InputOutputSlopeTriplet newpoint = new InputOutputSlopeTriplet(xnew, fnew, null);
        this.getRootBracket().setOtherPoint(newpoint);
        if (fnew == 0.0) {
            return false;
        }
        if (fmid * fnew < 0.0) {
            this.getRootBracket().setLowerBound(midpoint);
            this.getRootBracket().setUpperBound(newpoint);
        } else if (f1 * fnew > 0.0) {
            this.getRootBracket().setLowerBound(newpoint);
        } else if (f2 * fnew > 0.0) {
            this.getRootBracket().setUpperBound(newpoint);
        } else {
            throw new IllegalArgumentException("You should never get here: f1: " + f1 + ", f2: " + f2 + ", fnew: " + fnew + ", fmid: " + fmid);
        }
        double delta = (Double)this.getRootBracket().getLowerBound().getInput() - (Double)this.getRootBracket().getUpperBound().getInput();
        return Math.abs(delta) > this.getTolerance();
    }
}

