/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.tree;

import gov.sandia.cognition.algorithm.AbstractIterativeAlgorithm;
import gov.sandia.cognition.learning.algorithm.tree.AbstractDecisionTreeNode;
import gov.sandia.cognition.learning.algorithm.tree.DeciderLearner;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.categorization.Categorizer;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public abstract class AbstractDecisionTreeLearner<InputType, OutputType>
extends AbstractIterativeAlgorithm
implements Serializable {
    protected DeciderLearner<? super InputType, OutputType, ?, ?> deciderLearner;

    public AbstractDecisionTreeLearner() {
        this(null);
    }

    public AbstractDecisionTreeLearner(DeciderLearner<? super InputType, OutputType, ?, ?> deciderLearner) {
        this.setDeciderLearner(deciderLearner);
    }

    protected abstract AbstractDecisionTreeNode<InputType, OutputType, ?> learnNode(Collection<? extends InputOutputPair<? extends InputType, OutputType>> var1, AbstractDecisionTreeNode<InputType, OutputType, ?> var2);

    protected <DecisionType> void learnChildNodes(AbstractDecisionTreeNode<InputType, OutputType, DecisionType> node, Collection<? extends InputOutputPair<? extends InputType, OutputType>> data, Categorizer<? super InputType, ? extends DecisionType> decider) {
        Map<DecisionType, LinkedList<InputOutputPair<InputType, OutputType>>> splitsMap = this.splitData(data, decider);
        if (splitsMap.size() < 2) {
            return;
        }
        for (Map.Entry<DecisionType, LinkedList<InputOutputPair<InputType, OutputType>>> entry : splitsMap.entrySet()) {
            DecisionType value = entry.getKey();
            AbstractDecisionTreeNode<InputType, OutputType, DecisionType> child = this.learnNode((Collection)entry.getValue(), node);
            if (child == null) continue;
            child.setIncomingValue(value);
            node.addChild(value, child);
        }
    }

    public <DecisionType> Map<DecisionType, LinkedList<InputOutputPair<? extends InputType, OutputType>>> splitData(Collection<? extends InputOutputPair<? extends InputType, OutputType>> data, Categorizer<? super InputType, ? extends DecisionType> decider) {
        HashMap splitsMap = new HashMap(2);
        for (InputOutputPair<InputType, OutputType> example : data) {
            Object value = decider.evaluate(example.getInput());
            LinkedList<InputOutputPair<InputType, OutputType>> split = (LinkedList<InputOutputPair<InputType, OutputType>>)splitsMap.get(value);
            if (split == null) {
                split = new LinkedList<InputOutputPair<InputType, OutputType>>();
                splitsMap.put(value, split);
            }
            split.add(example);
        }
        return splitsMap;
    }

    public boolean areAllOutputsEqual(Collection<? extends InputOutputPair<? extends InputType, OutputType>> data) {
        Object allOutput = null;
        for (InputOutputPair<InputType, OutputType> example : data) {
            OutputType output = example.getOutput();
            if (allOutput == null) {
                allOutput = output;
                continue;
            }
            if (output == null || allOutput.equals(output)) continue;
            return false;
        }
        return true;
    }

    public DeciderLearner<? super InputType, OutputType, ?, ?> getDeciderLearner() {
        return this.deciderLearner;
    }

    public void setDeciderLearner(DeciderLearner<? super InputType, OutputType, ?, ?> deciderLearner) {
        this.deciderLearner = deciderLearner;
    }
}

