/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.data;

import gov.sandia.cognition.learning.data.AbstractValueDiscriminantPair;
import gov.sandia.cognition.util.ObjectUtil;

public class DefaultValueDiscriminantPair<ValueType, DiscriminantType extends Comparable<? super DiscriminantType>>
extends AbstractValueDiscriminantPair<ValueType, DiscriminantType> {
    protected ValueType value;
    protected DiscriminantType discriminant;

    public DefaultValueDiscriminantPair() {
        this(null, null);
    }

    public DefaultValueDiscriminantPair(ValueType value, DiscriminantType discriminant) {
        this.setValue(value);
        this.setDiscriminant(discriminant);
    }

    @Override
    public DefaultValueDiscriminantPair<ValueType, DiscriminantType> clone() {
        DefaultValueDiscriminantPair clone = (DefaultValueDiscriminantPair)super.clone();
        clone.value = ObjectUtil.cloneSmart(this.value);
        clone.discriminant = (Comparable)ObjectUtil.cloneSmart(this.discriminant);
        return clone;
    }

    @Override
    public ValueType getValue() {
        return this.value;
    }

    public void setValue(ValueType value) {
        this.value = value;
    }

    @Override
    public DiscriminantType getDiscriminant() {
        return this.discriminant;
    }

    public void setDiscriminant(DiscriminantType discriminant) {
        this.discriminant = discriminant;
    }

    public static <ValueType, DiscriminantType extends Comparable<? super DiscriminantType>> DefaultValueDiscriminantPair<ValueType, DiscriminantType> create(ValueType value, DiscriminantType discriminant) {
        return new DefaultValueDiscriminantPair<ValueType, DiscriminantType>(value, discriminant);
    }
}

