/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.data;

import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.learning.data.WeightedInputOutputPair;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DefaultWeightedInputOutputPair<InputType, OutputType>
extends DefaultInputOutputPair<InputType, OutputType>
implements WeightedInputOutputPair<InputType, OutputType> {
    public static final double DEFAULT_WEIGHT = 1.0;
    private double weight;

    public DefaultWeightedInputOutputPair() {
        this(null, null, 1.0);
    }

    public DefaultWeightedInputOutputPair(InputType input, OutputType output, double weight) {
        super(input, output);
        this.setWeight(weight);
    }

    public DefaultWeightedInputOutputPair(Pair<? extends InputType, ? extends OutputType> pair, double weight) {
        this(pair.getFirst(), pair.getSecond(), weight);
    }

    public DefaultWeightedInputOutputPair(WeightedInputOutputPair<? extends InputType, ? extends OutputType> other) {
        this(other.getInput(), other.getOutput(), other.getWeight());
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public static <InputType, OutputType> DefaultWeightedInputOutputPair<InputType, OutputType> create() {
        return new DefaultWeightedInputOutputPair<InputType, OutputType>();
    }

    public static <InputType, OutputType> DefaultWeightedInputOutputPair<InputType, OutputType> create(InputType input, OutputType output, double weight) {
        return new DefaultWeightedInputOutputPair<InputType, OutputType>(input, output, weight);
    }

    public static <InputType, OutputType> ArrayList<DefaultWeightedInputOutputPair<InputType, OutputType>> mergeCollections(Collection<InputType> inputs, Collection<OutputType> outputs, Collection<? extends Number> weights) {
        int count = inputs.size();
        if (count != outputs.size() && count != weights.size()) {
            throw new IllegalArgumentException("The inputs, outputs, and weights collections must be the same size (" + inputs.size() + ", " + outputs.size() + ", " + weights.size() + ")");
        }
        Iterator<InputType> ii = inputs.iterator();
        Iterator<OutputType> io = outputs.iterator();
        Iterator<? extends Number> iw = weights.iterator();
        ArrayList<DefaultWeightedInputOutputPair<InputType, OutputType>> result = new ArrayList<DefaultWeightedInputOutputPair<InputType, OutputType>>(count);
        for (int n = 0; n < count; ++n) {
            result.add(DefaultWeightedInputOutputPair.create(ii.next(), io.next(), iw.next().doubleValue()));
        }
        return result;
    }
}

