/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.data.feature;

import gov.sandia.cognition.collection.FiniteCapacityBuffer;
import gov.sandia.cognition.evaluator.AbstractStatefulEvaluator;

public class DelayFunction<DataType>
extends AbstractStatefulEvaluator<DataType, DataType, FiniteCapacityBuffer<DataType>> {
    private int delaySamples;

    public DelayFunction() {
        this(0);
    }

    public DelayFunction(int delaySamples) {
        this.setDelaySamples(delaySamples);
    }

    public DelayFunction(DelayFunction<DataType> other) {
        this(other.getDelaySamples());
        this.setState(((FiniteCapacityBuffer)other.getState()).clone());
    }

    @Override
    public DelayFunction<DataType> clone() {
        return (DelayFunction)super.clone();
    }

    public int getDelaySamples() {
        return this.delaySamples;
    }

    public void setDelaySamples(int delaySamples) {
        if (delaySamples < 0) {
            throw new IllegalArgumentException("Delay must be >= 0");
        }
        this.delaySamples = delaySamples;
        this.setState(null);
    }

    @Override
    public FiniteCapacityBuffer<DataType> createDefaultState() {
        return new FiniteCapacityBuffer(this.getDelaySamples() + 1);
    }

    @Override
    public DataType evaluate(DataType input) {
        ((FiniteCapacityBuffer)this.getState()).addLast(input);
        return ((FiniteCapacityBuffer)this.getState()).iterator().next();
    }
}

