/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.data.feature;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.collection.FiniteCapacityBuffer;
import gov.sandia.cognition.evaluator.AbstractStatefulEvaluator;
import gov.sandia.cognition.math.RingAccumulator;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2006-07-17", changesNeeded=false, comments={"Encapsulated members, added a comment to virtually every method and member.", "Added comment about the regression equation.", "No additional changes needed."})
public class LinearRegressionCoefficientExtractor
extends AbstractStatefulEvaluator<Vector, Vector, FiniteCapacityBuffer<Vector>> {
    public static final int DEFAULT_MAX_BUFFER_SIZE = 20;
    private int maxBufferSize;

    public LinearRegressionCoefficientExtractor() {
        this(20);
    }

    public LinearRegressionCoefficientExtractor(int maxBufferSize) {
        this.setMaxBufferSize(maxBufferSize);
    }

    @Override
    public LinearRegressionCoefficientExtractor clone() {
        LinearRegressionCoefficientExtractor clone = (LinearRegressionCoefficientExtractor)super.clone();
        if (this.getState() != null) {
            clone.setState(((FiniteCapacityBuffer)this.getState()).clone());
        }
        return clone;
    }

    @Override
    public FiniteCapacityBuffer<Vector> createDefaultState() {
        return new FiniteCapacityBuffer<Vector>(this.getMaxBufferSize());
    }

    @Override
    public Vector evaluate(Vector input) {
        Vector bs;
        Vector ms;
        int M = input.getDimensionality();
        ((FiniteCapacityBuffer)this.getState()).addLast(input);
        int num = ((FiniteCapacityBuffer)this.getState()).size();
        RingAccumulator sumy = new RingAccumulator((Iterable)this.getState());
        Vector meany = (Vector)sumy.getMean();
        if (num > 1) {
            double meanx = (double)(-(num - 1)) / 2.0;
            double sxx = 0.0;
            RingAccumulator sumxy = new RingAccumulator();
            int x = -num + 1;
            for (Vector y : (FiniteCapacityBuffer)this.getState()) {
                double dx = (double)x - meanx;
                sxx += dx * dx;
                sumxy.accumulate(y.minus(meany).scale(dx));
                ++x;
            }
            ms = (Vector)sumxy.scaleSum(1.0 / sxx);
            bs = (Vector)meany.minus(ms.scale(meanx));
        } else {
            ms = VectorFactory.getDefault().createVector(M);
            bs = meany;
        }
        return bs.stack(ms);
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        if (maxBufferSize < 2) {
            throw new IllegalArgumentException("Must have at least 2 samples to fit two polynomials!!");
        }
        this.maxBufferSize = maxBufferSize;
        this.setState(null);
    }
}

