/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.experiment;

import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.learning.data.PartitionedDataset;
import gov.sandia.cognition.learning.experiment.AbstractValidationFoldExperiment;
import gov.sandia.cognition.learning.experiment.ValidationFoldCreator;
import gov.sandia.cognition.learning.performance.PerformanceEvaluator;
import gov.sandia.cognition.statistics.method.ConfidenceStatistic;
import gov.sandia.cognition.statistics.method.NullHypothesisEvaluator;
import gov.sandia.cognition.util.DefaultPair;
import gov.sandia.cognition.util.Pair;
import gov.sandia.cognition.util.Summarizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LearnerComparisonExperiment<InputDataType, FoldDataType, LearnedType, StatisticType, SummaryType>
extends AbstractValidationFoldExperiment<InputDataType, FoldDataType>
implements Serializable {
    protected PerformanceEvaluator<? super LearnedType, Collection<? extends FoldDataType>, ? extends StatisticType> performanceEvaluator;
    protected Summarizer<? super StatisticType, ? extends SummaryType> summarizer;
    private NullHypothesisEvaluator<Collection<? extends StatisticType>> statisticalTest;
    protected Pair<BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType>, BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType>> learners;
    protected DefaultPair<ArrayList<StatisticType>, ArrayList<StatisticType>> statistics;
    protected ConfidenceStatistic confidence;
    protected DefaultPair<SummaryType, SummaryType> summaries;

    public LearnerComparisonExperiment() {
        this(null, null, null, null);
    }

    public LearnerComparisonExperiment(ValidationFoldCreator<InputDataType, FoldDataType> foldCreator, PerformanceEvaluator<? super LearnedType, Collection<? extends FoldDataType>, ? extends StatisticType> performanceEvaluator, NullHypothesisEvaluator<Collection<? extends StatisticType>> statisticalTest, Summarizer<? super StatisticType, ? extends SummaryType> summarizer) {
        super(foldCreator);
        this.setPerformanceEvaluator(performanceEvaluator);
        this.setStatisticalTest(statisticalTest);
        this.setSummarizer(summarizer);
        this.setStatistics(null);
        this.setConfidence(null);
        this.setSummaries(null);
    }

    public Result<SummaryType> evaluate(Pair<BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType>, BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType>> learners, Collection<? extends InputDataType> data) {
        List folds = this.getFoldCreator().createFolds(data);
        this.setLearners(learners);
        this.setStatistics(new DefaultPair<ArrayList<StatisticType>, ArrayList<StatisticType>>(new ArrayList(folds.size()), new ArrayList(folds.size())));
        this.runExperiment(folds);
        this.setConfidence(this.getStatisticalTest().evaluateNullHypothesis(this.getStatistics().getFirst(), this.getStatistics().getSecond()));
        SummaryType summary1 = this.getSummarizer().summarize((Collection)this.getStatistics().getFirst());
        SummaryType summary2 = this.getSummarizer().summarize((Collection)this.getStatistics().getSecond());
        this.setSummaries(new DefaultPair<SummaryType, SummaryType>(summary1, summary2));
        return new Result<SummaryType>(this.getConfidence(), this.getSummaries());
    }

    @Override
    protected void runTrial(PartitionedDataset<FoldDataType> fold) {
        LearnedType learned1 = this.getLearners().getFirst().learn(fold.getTrainingSet());
        StatisticType statistic1 = this.getPerformanceEvaluator().evaluatePerformance(learned1, fold.getTestingSet());
        this.getStatistics().getFirst().add(statistic1);
        LearnedType learned2 = this.getLearners().getSecond().learn(fold.getTrainingSet());
        StatisticType statistic2 = this.getPerformanceEvaluator().evaluatePerformance(learned2, fold.getTestingSet());
        this.getStatistics().getSecond().add(statistic2);
    }

    public Result<SummaryType> evaluate(BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType> learner1, BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType> learner2, Collection<? extends InputDataType> data) {
        return this.evaluate(new DefaultPair<BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType>, BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType>>(learner1, learner2), data);
    }

    public PerformanceEvaluator<? super LearnedType, Collection<? extends FoldDataType>, ? extends StatisticType> getPerformanceEvaluator() {
        return this.performanceEvaluator;
    }

    public void setPerformanceEvaluator(PerformanceEvaluator<? super LearnedType, Collection<? extends FoldDataType>, ? extends StatisticType> performanceEvaluator) {
        this.performanceEvaluator = performanceEvaluator;
    }

    public Summarizer<? super StatisticType, ? extends SummaryType> getSummarizer() {
        return this.summarizer;
    }

    public void setSummarizer(Summarizer<? super StatisticType, ? extends SummaryType> summarizer) {
        this.summarizer = summarizer;
    }

    public NullHypothesisEvaluator<Collection<? extends StatisticType>> getStatisticalTest() {
        return this.statisticalTest;
    }

    public void setStatisticalTest(NullHypothesisEvaluator<Collection<? extends StatisticType>> statisticalTest) {
        this.statisticalTest = statisticalTest;
    }

    public Pair<BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType>, BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType>> getLearners() {
        return this.learners;
    }

    protected void setLearners(Pair<BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType>, BatchLearner<? super Collection<? extends FoldDataType>, ? extends LearnedType>> learners) {
        this.learners = learners;
    }

    public DefaultPair<ArrayList<StatisticType>, ArrayList<StatisticType>> getStatistics() {
        return this.statistics;
    }

    protected void setStatistics(DefaultPair<ArrayList<StatisticType>, ArrayList<StatisticType>> statistics) {
        this.statistics = statistics;
    }

    public ConfidenceStatistic getConfidence() {
        return this.confidence;
    }

    protected void setConfidence(ConfidenceStatistic confidence) {
        this.confidence = confidence;
    }

    public DefaultPair<SummaryType, SummaryType> getSummaries() {
        return this.summaries;
    }

    protected void setSummaries(DefaultPair<SummaryType, SummaryType> summaries) {
        this.summaries = summaries;
    }

    public static class Result<SummaryType> {
        private ConfidenceStatistic confidence;
        private DefaultPair<SummaryType, SummaryType> summaries;

        public Result(ConfidenceStatistic confidence, DefaultPair<SummaryType, SummaryType> summaries) {
            this.setConfidence(confidence);
            this.setSummaries(summaries);
        }

        public ConfidenceStatistic getConfidence() {
            return this.confidence;
        }

        public void setConfidence(ConfidenceStatistic confidence) {
            this.confidence = confidence;
        }

        public DefaultPair<SummaryType, SummaryType> getSummaries() {
            return this.summaries;
        }

        public void setSummaries(DefaultPair<SummaryType, SummaryType> summaries) {
            this.summaries = summaries;
        }
    }
}

