/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;

public abstract class LinearCombinationFunction<InputType, OutputType>
extends AbstractCloneableSerializable
implements Evaluator<InputType, OutputType>,
Vectorizable {
    private ArrayList<? extends Evaluator<? super InputType, ? extends OutputType>> basisFunctions;
    private Vector coefficients;

    public LinearCombinationFunction(ArrayList<? extends Evaluator<? super InputType, ? extends OutputType>> basisFunctions, Vector coefficients) {
        this.setBasisFunctions(basisFunctions);
        this.setCoefficients(coefficients);
    }

    @Override
    public LinearCombinationFunction<InputType, OutputType> clone() {
        LinearCombinationFunction clone = (LinearCombinationFunction)super.clone();
        clone.setBasisFunctions(ObjectUtil.cloneSmartElementsAsArrayList(this.getBasisFunctions()));
        clone.setCoefficients(ObjectUtil.cloneSafe(this.getCoefficients()));
        return clone;
    }

    public Vector getCoefficients() {
        return this.coefficients;
    }

    public void setCoefficients(Vector coefficients) {
        if (coefficients.getDimensionality() != this.getBasisFunctions().size()) {
            throw new IllegalArgumentException("Must have as many coefficients as basis functions!");
        }
        this.coefficients = coefficients;
    }

    public ArrayList<? extends Evaluator<? super InputType, ? extends OutputType>> getBasisFunctions() {
        return this.basisFunctions;
    }

    public void setBasisFunctions(ArrayList<? extends Evaluator<? super InputType, ? extends OutputType>> basisFunctions) {
        this.basisFunctions = basisFunctions;
    }

    @Override
    public Vector convertToVector() {
        return this.getCoefficients();
    }

    @Override
    public void convertFromVector(Vector parameters) {
        this.setCoefficients(parameters);
    }

    public String toString() {
        int num = this.getBasisFunctions().size();
        StringBuilder builder = new StringBuilder(10 * num);
        for (int i = 0; i < num; ++i) {
            builder.append(this.getCoefficients().getElement(i) + "*" + this.getBasisFunctions().get(i) + " + ");
        }
        return builder.toString();
    }

    @Override
    public abstract OutputType evaluate(InputType var1);
}

