/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.categorization;

import gov.sandia.cognition.learning.data.DefaultWeightedValueDiscriminant;
import gov.sandia.cognition.learning.data.ValueDiscriminantPair;
import gov.sandia.cognition.learning.function.categorization.AbstractBinaryCategorizer;
import gov.sandia.cognition.learning.function.categorization.DiscriminantBinaryCategorizer;

public abstract class AbstractDiscriminantBinaryCategorizer<InputType>
extends AbstractBinaryCategorizer<InputType>
implements DiscriminantBinaryCategorizer<InputType> {
    @Override
    public Boolean evaluate(InputType input) {
        return this.evaluateAsDouble(input) >= 0.0;
    }

    @Override
    public ValueDiscriminantPair<Boolean, Double> evaluateWithDiscriminant(InputType input) {
        double value = this.evaluateAsDouble(input);
        boolean category = value >= 0.0;
        double discriminant = category ? value : -value;
        return DefaultWeightedValueDiscriminant.create(category, discriminant);
    }
}

