/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.categorization;

import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.AbstractBatchLearnerContainer;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.data.DatasetUtil;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.learning.data.DefaultWeightedValueDiscriminant;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.categorization.AbstractDiscriminantCategorizer;
import gov.sandia.cognition.statistics.distribution.MapBasedDataHistogram;
import gov.sandia.cognition.util.DefaultPair;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class BinaryVersusCategorizer<InputType, CategoryType>
extends AbstractDiscriminantCategorizer<InputType, CategoryType, Double> {
    protected Map<Pair<CategoryType, CategoryType>, Evaluator<? super InputType, Boolean>> categoryPairsToEvaluatorMap;

    public BinaryVersusCategorizer() {
        this(new LinkedHashSet(), new LinkedHashMap<Pair<CategoryType, CategoryType>, Evaluator<? super InputType, Boolean>>());
    }

    public BinaryVersusCategorizer(Set<CategoryType> categories) {
        this(categories, new LinkedHashMap<Pair<CategoryType, CategoryType>, Evaluator<? super InputType, Boolean>>(categories.size() * categories.size() / 2));
    }

    public BinaryVersusCategorizer(Set<CategoryType> categories, Map<Pair<CategoryType, CategoryType>, Evaluator<? super InputType, Boolean>> categoryPairsToEvaluatorMap) {
        super(categories);
        this.setCategoryPairsToEvaluatorMap(categoryPairsToEvaluatorMap);
    }

    @Override
    public BinaryVersusCategorizer<InputType, CategoryType> clone() {
        BinaryVersusCategorizer result = (BinaryVersusCategorizer)super.clone();
        result.categoryPairsToEvaluatorMap = new LinkedHashMap<Pair<CategoryType, CategoryType>, Evaluator<? super InputType, Boolean>>(this.categoryPairsToEvaluatorMap.size());
        for (Map.Entry<Pair<CategoryType, CategoryType>, Evaluator<InputType, Boolean>> entry : this.categoryPairsToEvaluatorMap.entrySet()) {
            result.categoryPairsToEvaluatorMap.put(ObjectUtil.cloneSmart(entry.getKey()), ObjectUtil.cloneSmart(entry.getValue()));
        }
        return result;
    }

    public DefaultWeightedValueDiscriminant<CategoryType> evaluateWithDiscriminant(InputType input) {
        int categoryCount = this.categories.size();
        if (categoryCount <= 0) {
            return null;
        }
        if (categoryCount == 1) {
            return DefaultWeightedValueDiscriminant.create(CollectionUtil.getFirst(this.categories), 1.0);
        }
        MapBasedDataHistogram<Object> results = new MapBasedDataHistogram<Object>(categoryCount);
        for (Map.Entry<Pair<CategoryType, CategoryType>, Evaluator<InputType, Boolean>> entry : this.categoryPairsToEvaluatorMap.entrySet()) {
            Boolean category = entry.getValue().evaluate(input);
            if (category == null) continue;
            if (!category.booleanValue()) {
                results.add(entry.getKey().getFirst());
                continue;
            }
            results.add(entry.getKey().getSecond());
        }
        Object bestCategory = results.getMaximumValue();
        double bestFraction = results.getFraction(bestCategory);
        return DefaultWeightedValueDiscriminant.create(bestCategory, bestFraction);
    }

    public Map<Pair<CategoryType, CategoryType>, Evaluator<? super InputType, Boolean>> getCategoryPairsToEvaluatorMap() {
        return this.categoryPairsToEvaluatorMap;
    }

    public void setCategoryPairsToEvaluatorMap(Map<Pair<CategoryType, CategoryType>, Evaluator<? super InputType, Boolean>> categoryPairsToEvaluatorMap) {
        this.categoryPairsToEvaluatorMap = categoryPairsToEvaluatorMap;
    }

    public static class Learner<InputType, CategoryType>
    extends AbstractBatchLearnerContainer<BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, Boolean>>>
    implements SupervisedBatchLearner<InputType, CategoryType, BinaryVersusCategorizer<InputType, CategoryType>> {
        public Learner() {
            this(null);
        }

        public Learner(BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, Boolean>> learner) {
            super(learner);
        }

        @Override
        public BinaryVersusCategorizer<InputType, CategoryType> learn(Collection<? extends InputOutputPair<? extends InputType, CategoryType>> data) {
            Set categories = DatasetUtil.findUniqueOutputs(data);
            int categoryCount = categories.size();
            ArrayList categoriesList = new ArrayList(categories);
            BinaryVersusCategorizer result = new BinaryVersusCategorizer(categories);
            for (int i = 0; i < categoryCount; ++i) {
                Object falseCategory = categoriesList.get(i);
                for (int j = i + 1; j < categoryCount; ++j) {
                    Object trueCategory = categoriesList.get(j);
                    ArrayList<DefaultInputOutputPair<InputType, Boolean>> versusData = new ArrayList<DefaultInputOutputPair<InputType, Boolean>>();
                    for (InputOutputPair<InputType, CategoryType> example : data) {
                        CategoryType category = example.getOutput();
                        if (falseCategory.equals(category)) {
                            versusData.add(new DefaultInputOutputPair<InputType, Boolean>(example.getInput(), false));
                            continue;
                        }
                        if (!trueCategory.equals(category)) continue;
                        versusData.add(new DefaultInputOutputPair<InputType, Boolean>(example.getInput(), true));
                    }
                    Evaluator learned = (Evaluator)this.getLearner().learn(versusData);
                    result.categoryPairsToEvaluatorMap.put(DefaultPair.create(falseCategory, trueCategory), learned);
                }
            }
            return result;
        }
    }
}

