/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.categorization;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.function.categorization.Categorizer;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.Set;

public class CompositeCategorizer<InputType, IntermediateType, CategoryType>
extends AbstractCloneableSerializable
implements Categorizer<InputType, CategoryType> {
    protected Evaluator<? super InputType, ? extends IntermediateType> preprocessor;
    protected Categorizer<? super IntermediateType, ? extends CategoryType> categorizer;

    public CompositeCategorizer() {
        this(null, null);
    }

    public CompositeCategorizer(Evaluator<? super InputType, ? extends IntermediateType> preprocessor, Categorizer<? super IntermediateType, ? extends CategoryType> categorizer) {
        this.setPreprocessor(preprocessor);
        this.setCategorizer(categorizer);
    }

    @Override
    public CompositeCategorizer<InputType, IntermediateType, CategoryType> clone() {
        CompositeCategorizer clone = (CompositeCategorizer)super.clone();
        clone.preprocessor = ObjectUtil.cloneSmart(this.preprocessor);
        clone.categorizer = ObjectUtil.cloneSmart(this.categorizer);
        return clone;
    }

    @Override
    public CategoryType evaluate(InputType input) {
        IntermediateType intermediate = this.preprocessor.evaluate(input);
        return (CategoryType)this.categorizer.evaluate(intermediate);
    }

    @Override
    public Set<? extends CategoryType> getCategories() {
        if (this.categorizer == null) {
            return null;
        }
        return this.categorizer.getCategories();
    }

    public Evaluator<? super InputType, ? extends IntermediateType> getPreprocessor() {
        return this.preprocessor;
    }

    public void setPreprocessor(Evaluator<? super InputType, ? extends IntermediateType> preprocessor) {
        this.preprocessor = preprocessor;
    }

    public Categorizer<? super IntermediateType, ? extends CategoryType> getCategorizer() {
        return this.categorizer;
    }

    public void setCategorizer(Categorizer<? super IntermediateType, ? extends CategoryType> categorizer) {
        this.categorizer = categorizer;
    }
}

