/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.categorization;

import gov.sandia.cognition.learning.function.categorization.AbstractDiscriminantBinaryCategorizer;
import gov.sandia.cognition.learning.function.categorization.ThresholdBinaryCategorizer;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.learning.function.kernel.KernelContainer;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Collection;

public class KernelBinaryCategorizer<InputType, EntryType extends WeightedValue<? extends InputType>>
extends AbstractDiscriminantBinaryCategorizer<InputType>
implements KernelContainer<InputType>,
ThresholdBinaryCategorizer<InputType> {
    public static final double DEFAULT_BIAS = 0.0;
    protected Kernel<? super InputType> kernel;
    protected Collection<EntryType> examples;
    protected double bias;

    public KernelBinaryCategorizer() {
        this((Kernel)null);
    }

    public KernelBinaryCategorizer(Kernel<? super InputType> kernel) {
        this(kernel, new ArrayList(), 0.0);
    }

    public KernelBinaryCategorizer(Kernel<? super InputType> kernel, Collection<EntryType> examples, double bias) {
        this.setExamples(examples);
        this.setBias(bias);
        this.setKernel(kernel);
    }

    public KernelBinaryCategorizer(KernelBinaryCategorizer<InputType, ? extends EntryType> other) {
        this(ObjectUtil.cloneSafe(other.getKernel()), other.getExamples() == null ? null : new ArrayList<EntryType>(other.getExamples()), other.getBias());
    }

    @Override
    public double evaluateAsDouble(InputType input) {
        double sum = this.bias;
        for (WeightedValue example : this.examples) {
            double weight = example.getWeight();
            if (weight == 0.0) continue;
            double value = this.kernel.evaluate(input, example.getValue());
            sum += weight * value;
        }
        return sum;
    }

    @Override
    public double getThreshold() {
        return -this.getBias();
    }

    @Override
    public void setThreshold(double threshold) {
        this.setBias(-threshold);
    }

    public Collection<EntryType> getExamples() {
        return this.examples;
    }

    public void setExamples(Collection<EntryType> examples) {
        this.examples = examples;
    }

    public double getBias() {
        return this.bias;
    }

    public void setBias(double bias) {
        this.bias = bias;
    }

    @Override
    public Kernel<? super InputType> getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel<? super InputType> kernel) {
        this.kernel = kernel;
    }
}

