/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.categorization;

import gov.sandia.cognition.learning.function.categorization.AbstractDiscriminantBinaryCategorizer;
import gov.sandia.cognition.learning.function.categorization.ThresholdBinaryCategorizer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorInputEvaluator;
import gov.sandia.cognition.math.matrix.VectorUtil;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.ObjectUtil;

public class LinearBinaryCategorizer
extends AbstractDiscriminantBinaryCategorizer<Vectorizable>
implements VectorInputEvaluator<Vectorizable, Boolean>,
ThresholdBinaryCategorizer<Vectorizable> {
    public static final double DEFAULT_BIAS = 0.0;
    private Vector weights;
    private double bias;

    public LinearBinaryCategorizer() {
        this(null, 0.0);
    }

    public LinearBinaryCategorizer(Vector weights, double bias) {
        this.setWeights(weights);
        this.setBias(bias);
    }

    public LinearBinaryCategorizer(LinearBinaryCategorizer other) {
        this(ObjectUtil.cloneSafe(other.getWeights()), other.getBias());
    }

    @Override
    public LinearBinaryCategorizer clone() {
        LinearBinaryCategorizer clone = (LinearBinaryCategorizer)super.clone();
        clone.weights = ObjectUtil.cloneSafe(this.weights);
        return clone;
    }

    @Override
    public double evaluateAsDouble(Vectorizable input) {
        return this.evaluateAsDouble(input.convertToVector());
    }

    @Override
    public double evaluateAsDouble(Vector input) {
        if (this.weights == null) {
            return this.bias;
        }
        return input.dotProduct(this.weights) + this.bias;
    }

    @Override
    public int getInputDimensionality() {
        return VectorUtil.safeGetDimensionality(this.weights);
    }

    @Override
    public double getThreshold() {
        return -this.getBias();
    }

    @Override
    public void setThreshold(double threshold) {
        this.setBias(-threshold);
    }

    public Vector getWeights() {
        return this.weights;
    }

    public void setWeights(Vector weights) {
        this.weights = weights;
    }

    public double getBias() {
        return this.bias;
    }

    public void setBias(double bias) {
        this.bias = bias;
    }

    public String toString() {
        return "Linear Binary Categorizer (weights = " + this.getWeights() + ", " + "bias = " + this.getBias() + ")";
    }
}

