/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.categorization;

import gov.sandia.cognition.learning.function.categorization.AbstractThresholdBinaryCategorizer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;

public class VectorElementThresholdCategorizer
extends AbstractThresholdBinaryCategorizer<Vectorizable> {
    public static final int DEFAULT_INDEX = -1;
    protected int index;

    public VectorElementThresholdCategorizer() {
        this(-1, 0.0);
    }

    public VectorElementThresholdCategorizer(int index, double threshold) {
        super(threshold);
        this.setIndex(index);
    }

    public VectorElementThresholdCategorizer(VectorElementThresholdCategorizer other) {
        this(other.getIndex(), other.getThreshold());
    }

    @Override
    public VectorElementThresholdCategorizer clone() {
        return (VectorElementThresholdCategorizer)super.clone();
    }

    @Override
    protected double evaluateWithoutThreshold(Vectorizable input) {
        Vector vector = input.convertToVector();
        return vector.getElement(this.index);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String toString() {
        return "f(x) = x[" + this.index + "] >= " + this.getThreshold();
    }
}

