/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.cost;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.Cluster;
import gov.sandia.cognition.learning.algorithm.clustering.divergence.ClusterDivergenceFunction;
import gov.sandia.cognition.learning.function.cost.CostFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.Collection;

@PublicationReference(author={"Christopher M. Bishop"}, title="Pattern Recognition and Machine Learning", type=PublicationType.Book, year=2006, pages={424, 428}, notes={"Section 9.1"}, url="http://research.microsoft.com/~cmbishop/PRML/")
public class ClusterDistortionMeasure<DataType, ClusterType extends Cluster<DataType>>
extends AbstractCloneableSerializable
implements CostFunction<Collection<? extends ClusterType>, ClusterDivergenceFunction<? super ClusterType, ? super DataType>> {
    private ClusterDivergenceFunction<? super ClusterType, ? super DataType> costParameters;

    public ClusterDistortionMeasure() {
        this(null);
    }

    public ClusterDistortionMeasure(ClusterDivergenceFunction<ClusterType, DataType> costParameters) {
        this.setCostParameters(costParameters);
    }

    @Override
    public ClusterDistortionMeasure<DataType, ClusterType> clone() {
        return (ClusterDistortionMeasure)super.clone();
    }

    @Override
    public Double evaluate(Collection<? extends ClusterType> target) {
        double sum = 0.0;
        for (Cluster cluster : target) {
            sum += this.evaluate((ClusterType)cluster).doubleValue();
        }
        return sum;
    }

    @Override
    public Double evaluate(ClusterType cluster) {
        double sum = 0.0;
        for (Object p : cluster.getMembers()) {
            this.costParameters.evaluate(cluster, p);
            sum += this.costParameters.evaluate(cluster, p);
        }
        return sum;
    }

    @Override
    public ClusterDivergenceFunction<? super ClusterType, ? super DataType> getCostParameters() {
        return this.costParameters;
    }

    @Override
    public void setCostParameters(ClusterDivergenceFunction<? super ClusterType, ? super DataType> costParameters) {
        this.costParameters = costParameters;
    }
}

