/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.cost;

import gov.sandia.cognition.learning.data.DatasetUtil;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.data.TargetEstimatePair;
import gov.sandia.cognition.learning.function.cost.AbstractSupervisedCostFunction;
import gov.sandia.cognition.math.matrix.Vector;
import java.util.Collection;

public class MeanL1CostFunction
extends AbstractSupervisedCostFunction<Vector, Vector> {
    public MeanL1CostFunction() {
        this((Collection<? extends InputOutputPair<? extends Vector, Vector>>)null);
    }

    public MeanL1CostFunction(Collection<? extends InputOutputPair<? extends Vector, Vector>> dataset) {
        super(dataset);
    }

    @Override
    public MeanL1CostFunction clone() {
        return (MeanL1CostFunction)super.clone();
    }

    @Override
    public Double evaluatePerformance(Collection<? extends TargetEstimatePair<Vector, Vector>> data) {
        double denominator = 0.0;
        double sumL1 = 0.0;
        for (TargetEstimatePair<Vector, Vector> targetEstimatePair : data) {
            Vector target = targetEstimatePair.getTarget();
            Vector estimate = targetEstimatePair.getEstimate();
            Vector error = target.minus(estimate);
            double weight = DatasetUtil.getWeight(targetEstimatePair);
            double errorL1 = weight * error.norm1();
            sumL1 += errorL1;
            denominator += weight;
        }
        double meanWeightedL1Error = 0.0;
        if (denominator != 0.0) {
            meanWeightedL1Error = sumL1 / denominator;
        }
        return meanWeightedL1Error;
    }
}

