/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.cost;

import gov.sandia.cognition.algorithm.ParallelAlgorithm;
import gov.sandia.cognition.algorithm.ParallelUtil;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.Cluster;
import gov.sandia.cognition.learning.algorithm.clustering.divergence.ClusterDivergenceFunction;
import gov.sandia.cognition.learning.function.cost.ClusterDistortionMeasure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParallelClusterDistortionMeasure<DataType, ClusterType extends Cluster<DataType>>
extends ClusterDistortionMeasure<DataType, ClusterType>
implements ParallelAlgorithm {
    private transient ArrayList<Callable<Double>> tasks;
    private transient ThreadPoolExecutor threadPool;

    public ParallelClusterDistortionMeasure() {
        this(null);
    }

    public ParallelClusterDistortionMeasure(ClusterDivergenceFunction<ClusterType, DataType> costParameters) {
        super(costParameters);
    }

    @Override
    public Double evaluate(Collection<? extends ClusterType> target) {
        double sum = 0.0;
        try {
            this.tasks = new ArrayList(target.size());
            for (Cluster cluster : target) {
                this.tasks.add(new ClusterDistortionTask(this, cluster));
            }
            ArrayList<Double> results = ParallelUtil.executeInParallel(this.tasks, this.getThreadPool());
            for (Double result : results) {
                sum += result.doubleValue();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(ClusterDistortionMeasure.class.getName()).log(Level.SEVERE, null, ex);
        }
        return sum;
    }

    @Override
    public ThreadPoolExecutor getThreadPool() {
        if (this.threadPool == null) {
            this.setThreadPool(ParallelUtil.createThreadPool());
        }
        return this.threadPool;
    }

    @Override
    public void setThreadPool(ThreadPoolExecutor threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public int getNumThreads() {
        return ParallelUtil.getNumThreads(this);
    }

    private static class ClusterDistortionTask
    implements Callable<Double> {
        ClusterType cluster;
        final /* synthetic */ ParallelClusterDistortionMeasure this$0;

        public ClusterDistortionTask(ClusterType cluster) {
            this.this$0 = var1_1;
            this.cluster = cluster;
        }

        @Override
        public Double call() {
            return ((ClusterDistortionMeasure)this.this$0).evaluate(this.cluster);
        }
    }
}

