/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.distance;

import gov.sandia.cognition.math.Semimetric;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;

public class CosineDistanceMetric
extends AbstractCloneableSerializable
implements Semimetric<Vectorizable> {
    public static final CosineDistanceMetric INSTANCE = new CosineDistanceMetric();

    @Override
    public double evaluate(Vectorizable first, Vectorizable second) {
        Vector firstVector = first.convertToVector();
        Vector secondVector = second.convertToVector();
        double dotProduct = firstVector.dotProduct(secondVector);
        double firstNormSquared = firstVector.norm2Squared();
        double secondNormSquared = secondVector.norm2Squared();
        if (dotProduct == 0.0) {
            if (firstNormSquared == 0.0 && secondNormSquared == 0.0) {
                return 0.0;
            }
            return 1.0;
        }
        double cosine = dotProduct / Math.sqrt(firstNormSquared * secondNormSquared);
        return 1.0 - cosine;
    }
}

