/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.kernel;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.learning.function.kernel.KernelContainer;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-08", changesNeeded=false, comments={"Made clone call super.clone.", "Looks fine otherwise."})
public class DefaultKernelContainer<InputType>
extends AbstractCloneableSerializable
implements KernelContainer<InputType> {
    protected Kernel<? super InputType> kernel;

    public DefaultKernelContainer() {
        this.setKernel(null);
    }

    public DefaultKernelContainer(Kernel<? super InputType> kernel) {
        this.setKernel(kernel);
    }

    public DefaultKernelContainer(DefaultKernelContainer<? super InputType> other) {
        this(ObjectUtil.cloneSafe(other.getKernel()));
    }

    @Override
    public DefaultKernelContainer<InputType> clone() {
        DefaultKernelContainer result = (DefaultKernelContainer)super.clone();
        result.kernel = ObjectUtil.cloneSafe(this.kernel);
        return result;
    }

    @Override
    public Kernel<? super InputType> getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel<? super InputType> kernel) {
        this.kernel = kernel;
    }
}

