/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.kernel;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-08", changesNeeded=false, comments={"Made clone call super.clone.", "Looks fine otherwise."})
public class DefaultKernelsContainer<InputType>
extends AbstractCloneableSerializable {
    protected Collection<? extends Kernel<? super InputType>> kernels;

    public DefaultKernelsContainer() {
        this(new ArrayList());
    }

    public DefaultKernelsContainer(Collection<? extends Kernel<? super InputType>> kernels) {
        this.setKernels(kernels);
    }

    public DefaultKernelsContainer(DefaultKernelsContainer<InputType> other) {
        ArrayList<Kernel<InputType>> localKernels = new ArrayList<Kernel<InputType>>(other.getKernels().size());
        for (Kernel<InputType> kernel : other.getKernels()) {
            localKernels.add(kernel);
        }
        this.setKernels(localKernels);
    }

    @Override
    public DefaultKernelsContainer<InputType> clone() {
        DefaultKernelsContainer clone = (DefaultKernelsContainer)super.clone();
        clone.setKernels(ObjectUtil.cloneSmartElementsAsArrayList(this.getKernels()));
        return clone;
    }

    public Collection<? extends Kernel<? super InputType>> getKernels() {
        return this.kernels;
    }

    public void setKernels(Collection<? extends Kernel<? super InputType>> kernels) {
        this.kernels = kernels;
    }
}

