/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.kernel;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-08", changesNeeded=false, comments={"Made clone call super.clone.", "Looks fine otherwise."})
public class LinearKernel
extends AbstractCloneableSerializable
implements Kernel<Vectorizable> {
    private static final LinearKernel INSTANCE = new LinearKernel();

    public static LinearKernel getInstance() {
        return INSTANCE;
    }

    @Override
    public LinearKernel clone() {
        return (LinearKernel)super.clone();
    }

    @Override
    public double evaluate(Vectorizable x, Vectorizable y) {
        return x.convertToVector().dotProduct(y.convertToVector());
    }
}

