/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.kernel;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-08", changesNeeded=false, comments={"Looks fine."})
public class PolynomialKernel
extends AbstractCloneableSerializable
implements Kernel<Vectorizable> {
    public static final int DEFAULT_DEGREE = 2;
    public static final double DEFAULT_CONSTANT = 1.0;
    protected int degree;
    protected double constant;

    public PolynomialKernel() {
        this(2);
    }

    public PolynomialKernel(int degree) {
        this(degree, 1.0);
    }

    public PolynomialKernel(int degree, double constant) {
        this.setDegree(degree);
        this.setConstant(constant);
    }

    public PolynomialKernel(PolynomialKernel other) {
        this(other.getDegree(), other.getConstant());
    }

    @Override
    public PolynomialKernel clone() {
        return (PolynomialKernel)super.clone();
    }

    @Override
    public double evaluate(Vectorizable x, Vectorizable y) {
        double product = x.convertToVector().dotProduct(y.convertToVector());
        return Math.pow(product + this.constant, this.degree);
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int degree) {
        if (degree <= 0) {
            throw new IllegalArgumentException("degree must be positive");
        }
        this.degree = degree;
    }

    public double getConstant() {
        return this.constant;
    }

    public void setConstant(double constant) {
        if (constant < 0.0) {
            throw new IllegalArgumentException("constant must be non-negative");
        }
        this.constant = constant;
    }
}

