/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.kernel;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-08", changesNeeded=false, comments={"Looks fine."})
public class RadialBasisKernel
extends AbstractCloneableSerializable
implements Kernel<Vectorizable> {
    public static final double DEFAULT_SIGMA = 1.0;
    private double sigma = 0.0;
    private double negativeTwoSigmaSquared = 0.0;

    public RadialBasisKernel() {
        this(1.0);
    }

    public RadialBasisKernel(double sigma) {
        this.setSigma(sigma);
    }

    public RadialBasisKernel(RadialBasisKernel other) {
        this(other.getSigma());
    }

    @Override
    public RadialBasisKernel clone() {
        return (RadialBasisKernel)super.clone();
    }

    @Override
    public double evaluate(Vectorizable x, Vectorizable y) {
        double distance = x.convertToVector().euclideanDistanceSquared(y.convertToVector());
        return Math.exp(distance / this.negativeTwoSigmaSquared);
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma must be positive");
        }
        this.sigma = sigma;
        this.negativeTwoSigmaSquared = -2.0 * sigma * sigma;
    }
}

