/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.kernel;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-08", changesNeeded=false, comments={"Made clone call super.clone.", "Looks fine otherwise."})
public class ScalarFunctionKernel<InputType>
extends AbstractCloneableSerializable
implements Kernel<InputType> {
    protected Evaluator<? super InputType, Double> function;

    public ScalarFunctionKernel() {
        this(null);
    }

    public ScalarFunctionKernel(Evaluator<? super InputType, Double> function) {
        this.setFunction(function);
    }

    @Override
    public ScalarFunctionKernel<InputType> clone() {
        ScalarFunctionKernel clone = (ScalarFunctionKernel)super.clone();
        clone.setFunction(ObjectUtil.cloneSmart(this.getFunction()));
        return clone;
    }

    @Override
    public double evaluate(InputType x, InputType y) {
        return this.function.evaluate(x) * this.function.evaluate(y);
    }

    public Evaluator<? super InputType, Double> getFunction() {
        return this.function;
    }

    public void setFunction(Evaluator<? super InputType, Double> function) {
        this.function = function;
    }
}

