/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.kernel;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-08", changesNeeded=false, comments={"Made clone call super.clone.", "Looks fine otherwise."})
public class SigmoidKernel
extends AbstractCloneableSerializable
implements Kernel<Vectorizable> {
    public static final double DEFAULT_KAPPA = 1.0;
    public static final double DEFAULT_CONSTANT = 0.0;
    protected double kappa;
    protected double constant;

    public SigmoidKernel() {
        this(1.0, 0.0);
    }

    public SigmoidKernel(double kappa, double constant) {
        this.setKappa(kappa);
        this.setConstant(constant);
    }

    public SigmoidKernel(SigmoidKernel other) {
        this(other.getKappa(), other.getConstant());
    }

    @Override
    public SigmoidKernel clone() {
        return (SigmoidKernel)super.clone();
    }

    @Override
    public double evaluate(Vectorizable x, Vectorizable y) {
        double product = x.convertToVector().dotProduct(y.convertToVector());
        return Math.tanh(this.kappa * product + this.constant);
    }

    public double getKappa() {
        return this.kappa;
    }

    public void setKappa(double kappa) {
        this.kappa = kappa;
    }

    public double getConstant() {
        return this.constant;
    }

    public void setConstant(double constant) {
        this.constant = constant;
    }
}

