/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.kernel;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.function.kernel.DefaultKernelContainer;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFunction;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.ObjectUtil;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-08", changesNeeded=false, comments={"Made clone call super.clone.", "Looks fine otherwise."})
public class VectorFunctionKernel
extends DefaultKernelContainer<Vector>
implements Kernel<Vectorizable> {
    protected VectorFunction function;

    public VectorFunctionKernel() {
        this((VectorFunction)null);
    }

    public VectorFunctionKernel(VectorFunction function) {
        this(function, null);
    }

    public VectorFunctionKernel(VectorFunction function, Kernel<? super Vector> kernel) {
        super(kernel);
        this.setFunction(function);
    }

    @Override
    public VectorFunctionKernel clone() {
        VectorFunctionKernel clone = (VectorFunctionKernel)super.clone();
        clone.setFunction(ObjectUtil.cloneSmart(this.getFunction()));
        return clone;
    }

    @Override
    public double evaluate(Vectorizable x, Vectorizable y) {
        Vector fx = (Vector)this.function.evaluate(x.convertToVector());
        Vector fy = (Vector)this.function.evaluate(y.convertToVector());
        if (this.kernel == null) {
            return fx.dotProduct(fy);
        }
        return this.kernel.evaluate(fx, fy);
    }

    public VectorFunction getFunction() {
        return this.function;
    }

    public void setFunction(VectorFunction function) {
        this.function = function;
    }
}

