/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.kernel;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.function.kernel.DefaultKernelContainer;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.Weighted;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-08", changesNeeded=false, comments={"Made clone call super.clone.", "Now implements Weighted interface.", "Looks fine otherwise."})
public class WeightedKernel<InputType>
extends DefaultKernelContainer<InputType>
implements Kernel<InputType>,
Weighted {
    public static final double DEFAULT_WEIGHT = 1.0;
    protected double weight;

    public WeightedKernel() {
        this(1.0, null);
    }

    public WeightedKernel(double weight, Kernel<? super InputType> kernel) {
        super(kernel);
        this.setWeight(weight);
    }

    @Override
    public WeightedKernel<InputType> clone() {
        WeightedKernel clone = (WeightedKernel)super.clone();
        clone.setKernel(ObjectUtil.cloneSafe(this.getKernel()));
        return clone;
    }

    @Override
    public double evaluate(InputType x, InputType y) {
        return this.weight * this.kernel.evaluate(x, y);
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        if (weight < 0.0) {
            throw new IllegalArgumentException("weight must be non-negative");
        }
        this.weight = weight;
    }
}

