/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.scalar;

import gov.sandia.cognition.math.AbstractDifferentiableUnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.Vectorizable;

public class CosineFunction
extends AbstractDifferentiableUnivariateScalarFunction
implements Vectorizable {
    public static final double TWO_PI = Math.PI * 2;
    private double amplitude;
    private double frequency;
    private double phase;

    public CosineFunction() {
        this(1.0, 1.0);
    }

    public CosineFunction(double amplitude, double frequency) {
        this(amplitude, frequency, 0.0);
    }

    public CosineFunction(double amplitude, double frequency, double phase) {
        this.setAmplitude(amplitude);
        this.setFrequency(frequency);
        this.setPhase(phase);
    }

    @Override
    public CosineFunction clone() {
        return (CosineFunction)super.clone();
    }

    @Override
    public double evaluate(double input) {
        return this.getAmplitude() * Math.cos(Math.PI * 2 * this.getFrequency() * input + this.getPhase());
    }

    @Override
    public double differentiate(double input) {
        double twopif = Math.PI * 2 * this.getFrequency();
        return -this.getAmplitude() * twopif * Math.sin(twopif * input + this.getPhase());
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(double amplitude) {
        this.amplitude = amplitude;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public double getPhase() {
        return this.phase;
    }

    public void setPhase(double phase) {
        this.phase = phase;
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.amplitude, this.frequency, this.phase);
    }

    @Override
    public void convertFromVector(Vector parameters) {
        if (parameters.getDimensionality() != 3) {
            throw new IllegalArgumentException("Expected three parameters: amplitude, frequency, phase");
        }
        this.amplitude = parameters.getElement(0);
        this.frequency = parameters.getElement(1);
        this.phase = parameters.getElement(2);
    }

    public String toString() {
        return this.getAmplitude() + "*cos( 2pi*" + this.getFrequency() + "*x + " + this.getPhase() + " )";
    }
}

