/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.scalar;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.function.kernel.DefaultKernelContainer;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Collection;

public class KernelScalarFunction<InputType>
extends DefaultKernelContainer<InputType>
implements Evaluator<InputType, Double> {
    public static final double DEFAULT_BIAS = 0.0;
    protected Collection<? extends WeightedValue<? extends InputType>> examples;
    protected double bias;

    public KernelScalarFunction() {
        this((Kernel)null);
    }

    public KernelScalarFunction(Kernel<? super InputType> kernel) {
        this(kernel, new ArrayList(), 0.0);
    }

    public KernelScalarFunction(Kernel<? super InputType> kernel, Collection<? extends WeightedValue<? extends InputType>> examples, double bias) {
        super(kernel);
        this.setExamples(examples);
        this.setBias(bias);
    }

    public KernelScalarFunction(KernelScalarFunction<InputType> other) {
        super(other);
        this.setExamples(other.getExamples() == null ? null : new ArrayList<WeightedValue<InputType>>(other.getExamples()));
        this.setBias(other.getBias());
    }

    @Override
    public Double evaluate(InputType input) {
        double sum = this.bias;
        for (WeightedValue<InputType> example : this.examples) {
            double weight = example.getWeight();
            if (weight == 0.0) continue;
            double value = this.kernel.evaluate(input, example.getValue());
            sum += weight * value;
        }
        return sum;
    }

    public Collection<? extends WeightedValue<? extends InputType>> getExamples() {
        return this.examples;
    }

    public void setExamples(Collection<? extends WeightedValue<? extends InputType>> examples) {
        this.examples = examples;
    }

    public double getBias() {
        return this.bias;
    }

    public void setBias(double bias) {
        this.bias = bias;
    }
}

