/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.scalar;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorInputEvaluator;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

public class LinearDiscriminant
extends AbstractCloneableSerializable
implements Evaluator<Vector, Double>,
Vectorizable,
VectorInputEvaluator<Vector, Double> {
    private Vector weightVector;

    public LinearDiscriminant() {
        this(null);
    }

    public LinearDiscriminant(Vector weightVector) {
        this.setWeightVector(weightVector);
    }

    @Override
    public LinearDiscriminant clone() {
        LinearDiscriminant clone = (LinearDiscriminant)super.clone();
        clone.setWeightVector(ObjectUtil.cloneSafe(this.getWeightVector()));
        return clone;
    }

    @Override
    public int getInputDimensionality() {
        return this.getWeightVector().getDimensionality();
    }

    public Vector getWeightVector() {
        return this.weightVector;
    }

    public void setWeightVector(Vector weightVector) {
        this.weightVector = weightVector;
    }

    @Override
    public Double evaluate(Vector input) {
        return this.getWeightVector().dotProduct(input);
    }

    @Override
    public Vector convertToVector() {
        return this.getWeightVector();
    }

    @Override
    public void convertFromVector(Vector parameters) {
        this.setWeightVector(parameters);
    }
}

