/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.scalar;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-06", changesNeeded=false, comments={"Made clone() call super.clone().", "Otherwise, class looks fine."})
public class LinearVectorScalarFunction
extends AbstractCloneableSerializable
implements Evaluator<Vectorizable, Double> {
    public static final double DEFAULT_BIAS = 0.0;
    private Vector weights;
    private double bias;

    public LinearVectorScalarFunction() {
        this((Vector)null);
    }

    public LinearVectorScalarFunction(Vector weights) {
        this(weights, 0.0);
    }

    public LinearVectorScalarFunction(Vector weights, double bias) {
        this.setWeights(weights);
        this.setBias(bias);
    }

    public LinearVectorScalarFunction(LinearVectorScalarFunction other) {
        this(ObjectUtil.cloneSafe(other.getWeights()), other.getBias());
    }

    @Override
    public LinearVectorScalarFunction clone() {
        LinearVectorScalarFunction clone = (LinearVectorScalarFunction)super.clone();
        clone.setWeights(ObjectUtil.cloneSafe(this.getWeights()));
        return clone;
    }

    @Override
    public Double evaluate(Vectorizable input) {
        return this.evaluateAsDouble(input);
    }

    public double evaluateAsDouble(Vectorizable input) {
        return this.evaluateAsDouble(input.convertToVector());
    }

    public double evaluateAsDouble(Vector input) {
        if (this.weights == null) {
            return this.bias;
        }
        return input.dotProduct(this.weights) + this.bias;
    }

    public Vector getWeights() {
        return this.weights;
    }

    public void setWeights(Vector weights) {
        this.weights = weights;
    }

    public double getBias() {
        return this.bias;
    }

    public void setBias(double bias) {
        this.bias = bias;
    }

    public String toString() {
        return "Linear Vector Scalar Function (weights = " + this.getWeights() + ", " + "bias = " + this.getBias() + ")";
    }
}

