/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.scalar;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.gradient.ParameterGradientEvaluator;
import gov.sandia.cognition.learning.algorithm.minimization.line.InputOutputSlopeTriplet;
import gov.sandia.cognition.learning.algorithm.regression.LinearRegression;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.scalar.VectorFunctionLinearDiscriminant;
import gov.sandia.cognition.math.AbstractDifferentiableUnivariateScalarFunction;
import gov.sandia.cognition.math.DifferentiableUnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import java.util.ArrayList;
import java.util.Collection;

public class PolynomialFunction
extends AbstractDifferentiableUnivariateScalarFunction
implements ParameterGradientEvaluator<Double, Vector> {
    private double exponent;

    public PolynomialFunction(double exponent) {
        this.setExponent(exponent);
    }

    public PolynomialFunction(PolynomialFunction other) {
        this(other.getExponent());
    }

    @Override
    public PolynomialFunction clone() {
        return (PolynomialFunction)super.clone();
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(this.getExponent());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        this.setExponent(parameters.getElement(0));
    }

    @Override
    public double differentiate(double input) {
        double a = this.getExponent();
        double dydx = a * Math.pow(input, a - 1.0);
        return dydx;
    }

    @Override
    public double evaluate(double input) {
        return Math.pow(input, this.exponent);
    }

    @Override
    public Vector computeParameterGradient(Double input) {
        double x = input;
        double a = this.exponent;
        double dyda = x == 0.0 ? 0.0 : Math.log(x) * Math.pow(x, a);
        Vector gradient = VectorFactory.getDefault().copyValues(dyda);
        return gradient;
    }

    public String toString() {
        return "x^" + this.getExponent();
    }

    public double getExponent() {
        return this.exponent;
    }

    public void setExponent(double exponent) {
        this.exponent = exponent;
    }

    public static ArrayList<PolynomialFunction> createPolynomials(double ... polynomialExponents) {
        int num = polynomialExponents.length;
        ArrayList<PolynomialFunction> functions = new ArrayList<PolynomialFunction>(num);
        for (int i = 0; i < num; ++i) {
            functions.add(new PolynomialFunction(polynomialExponents[i]));
        }
        return functions;
    }

    public static class Regression
    extends LinearRegression<Double> {
        public Regression(double ... polynomialExponents) {
            super(PolynomialFunction.createPolynomials(polynomialExponents));
        }

        public static VectorFunctionLinearDiscriminant<Double> learn(int maxOrder, Collection<? extends InputOutputPair<Double, Double>> data) {
            double[] polynomialExponents = new double[maxOrder + 1];
            for (int i = 0; i < polynomialExponents.length; ++i) {
                polynomialExponents[i] = i;
            }
            Regression r = new Regression(polynomialExponents);
            return r.learn(data);
        }
    }

    public static class Cubic
    extends Quadratic
    implements ClosedForm {
        private double q3;

        public Cubic(double q0, double q1, double q2, double q3) {
            super(q0, q1, q2);
            this.setQ3(q3);
        }

        public Cubic(Cubic other) {
            super(other);
            this.setQ3(other.getQ3());
        }

        @Override
        public Cubic clone() {
            return (Cubic)super.clone();
        }

        @Override
        public String toString() {
            return super.toString() + " + " + this.getQ3() + "x^3";
        }

        @Override
        public double evaluate(double input) {
            return Cubic.evaluate(input, this.getQ0(), this.getQ1(), this.getQ2(), this.getQ3());
        }

        @Override
        public double differentiate(double input) {
            return Quadratic.evaluate(input, this.getQ1(), 2.0 * this.getQ2(), 3.0 * this.getQ3());
        }

        @Override
        public Double[] roots() {
            throw new IllegalArgumentException("Not yet implemented");
        }

        @Override
        public Double[] stationaryPoints() {
            return Cubic.stationaryPoints(this.getQ0(), this.getQ1(), this.getQ2(), this.getQ3());
        }

        public static double evaluate(double x, double q0, double q1, double q2, double q3) {
            return q0 + x * (q1 + x * (q2 + x * q3));
        }

        public static Double[] stationaryPoints(double q0, double q1, double q2, double q3) {
            double p0 = q1;
            double p1 = 2.0 * q2;
            double p2 = 3.0 * q3;
            return Quadratic.roots(p0, p1, p2);
        }

        public double getQ3() {
            return this.q3;
        }

        public void setQ3(double q3) {
            this.q3 = q3;
        }

        public static Cubic fit(InputOutputSlopeTriplet p0, InputOutputSlopeTriplet p1) {
            double x0 = (Double)p0.getInput();
            double x1 = (Double)p1.getInput();
            double x02 = x0 * x0;
            double x12 = x1 * x1;
            double y0 = (Double)p0.getOutput();
            double m0 = p0.getSlope();
            double y1 = (Double)p1.getOutput();
            double m1 = p1.getSlope();
            double dy = y1 - y0;
            double dx = x1 - x0;
            double m1pm0 = m1 + m0;
            double denom = dx * dx * dx;
            if (Math.abs(denom) <= 0.0) {
                throw new IllegalArgumentException("Cubic interpolation points are effectively collinear: " + denom);
            }
            double v3 = dx * m1pm0 - 2.0 * dy;
            double v2 = x02 * (m1 + m1pm0) - x12 * (m0 + m1pm0) + 3.0 * (x1 + x0) * dy - x0 * x1 * (m1 - m0);
            double v1 = x12 * (x0 * (m1 + m1pm0) + x1 * m0) - x02 * (x1 * (m0 + m1pm0) + x0 * m1) - 6.0 * x0 * x1 * dy;
            double v0 = x12 * (x1 * (y0 - x0 * m0) + x0 * (x0 * (m0 - m1) - 3.0 * y0)) + x02 * (x0 * (x1 * m1 - y1) + 3.0 * y1 * x1);
            double q3 = v3 / denom;
            double q2 = v2 / denom;
            double q1 = v1 / denom;
            double q0 = v0 / denom;
            return new Cubic(q0, q1, q2, q3);
        }
    }

    public static class Quadratic
    extends Linear {
        private double q2;

        public Quadratic(double q0, double q1, double q2) {
            super(q0, q1);
            this.setQ2(q2);
        }

        public Quadratic(Quadratic other) {
            this(other.getQ0(), other.getQ1(), other.getQ2());
        }

        @Override
        public Quadratic clone() {
            return (Quadratic)super.clone();
        }

        @Override
        public String toString() {
            return super.toString() + " + " + this.getQ2() + "x^2";
        }

        @Override
        public double evaluate(double input) {
            return Quadratic.evaluate(input, this.getQ0(), this.getQ1(), this.getQ2());
        }

        @Override
        public double differentiate(double input) {
            return this.getQ1() + 2.0 * this.getQ2() * input;
        }

        @Override
        public Double[] roots() {
            return Quadratic.roots(this.getQ0(), this.getQ1(), this.getQ2());
        }

        @Override
        public Double[] stationaryPoints() {
            return Quadratic.stationaryPoints(this.getQ0(), this.getQ1(), this.getQ2());
        }

        public static double evaluate(double x, double q0, double q1, double q2) {
            return q0 + x * (q1 + x * q2);
        }

        public static Quadratic fit(InputOutputPair<Double, Double> p0, InputOutputPair<Double, Double> p1, InputOutputPair<Double, Double> p2) {
            double x0 = p0.getInput();
            double x1 = p1.getInput();
            double x2 = p2.getInput();
            double x02 = x0 * x0;
            double x12 = x1 * x1;
            double x22 = x2 * x2;
            double y0 = p0.getOutput();
            double y1 = p1.getOutput();
            double y2 = p2.getOutput();
            double denom = (x0 - x2) * (x1 - x2) * (x1 - x0);
            if (Math.abs(denom) <= 0.0) {
                throw new IllegalArgumentException("Parabolic interpolation points are effectively collinear: " + denom);
            }
            double v2 = x0 * (y1 - y2) + x1 * (y2 - y0) + x2 * (y0 - y1);
            double v1 = x02 * (y2 - y1) + x12 * (y0 - y2) + x22 * (y1 - y0);
            double v0 = x02 * (x2 * y1 - x1 * y2) + x12 * (x0 * y2 - x2 * y0) + x22 * (x1 * y0 - x0 * y1);
            double q2 = v2 / denom;
            double q1 = v1 / denom;
            double q0 = v0 / denom;
            return new Quadratic(q0, q1, q2);
        }

        public static Quadratic fit(InputOutputSlopeTriplet p0, InputOutputPair<Double, Double> p1) {
            double x0 = (Double)p0.getInput();
            double x1 = p1.getInput();
            double x02 = x0 * x0;
            double x12 = x1 * x1;
            double y0 = (Double)p0.getOutput();
            double m0 = p0.getSlope();
            double y1 = p1.getOutput();
            double dy = y0 - y1;
            double dx = x0 - x1;
            double denom = dx * dx;
            if (Math.abs(denom) <= 0.0) {
                throw new IllegalArgumentException("Parabolic interpolation points are effectively collinear: " + denom);
            }
            double v2 = m0 * dx - dy;
            double v1 = m0 * (x12 - x02) + 2.0 * x0 * dy;
            double v0 = x02 * (y1 + x1 * m0) + x12 * (y0 - x0 * m0) - 2.0 * y0 * x0 * x1;
            double q2 = v2 / denom;
            double q1 = v1 / denom;
            double q0 = v0 / denom;
            return new Quadratic(q0, q1, q2);
        }

        @PublicationReference(author={"Wikipedia"}, title="Quadratic formula", type=PublicationType.WebPage, year=2008, url="http://en.wikipedia.org/wiki/Quadratic_formula#Quadratic_formula")
        public static Double[] roots(double q0, double q1, double q2) {
            if (Math.abs(q2) <= 0.0) {
                if (Math.abs(q1) <= 0.0) {
                    return new Double[0];
                }
                double xstar = -q0 / q1;
                return new Double[]{xstar};
            }
            double discriminant = q1 * q1 - 4.0 * q2 * q0;
            if (discriminant < 0.0) {
                return new Double[0];
            }
            if (Math.abs(discriminant) <= 0.0) {
                double xstar = -0.5 * q1 / q2;
                return new Double[]{xstar};
            }
            double denom = -2.0 * q2;
            double sqrtdisc = Math.sqrt(discriminant);
            double xpos = (q1 + sqrtdisc) / denom;
            double xneg = (q1 - sqrtdisc) / denom;
            return new Double[]{xpos, xneg};
        }

        public static Double[] stationaryPoints(double q0, double q1, double q2) {
            if (Math.abs(q2) <= 0.0) {
                return new Double[0];
            }
            return new Double[]{q1 / (-2.0 * q2)};
        }

        public double getQ2() {
            return this.q2;
        }

        public void setQ2(double q2) {
            this.q2 = q2;
        }
    }

    public static class Linear
    extends AbstractDifferentiableUnivariateScalarFunction
    implements ClosedForm {
        private double q0;
        private double q1;
        public static final double COLLINEAR_TOLERANCE = 0.0;

        public Linear(double q0, double q1) {
            this.setQ0(q0);
            this.setQ1(q1);
        }

        @Override
        public Linear clone() {
            return (Linear)super.clone();
        }

        @Override
        public double evaluate(double input) {
            return this.getQ0() + this.getQ1() * input;
        }

        @Override
        public double differentiate(double input) {
            return this.getQ1();
        }

        @Override
        public Double[] roots() {
            if (Math.abs(this.getQ1()) <= 0.0) {
                return new Double[0];
            }
            return new Double[]{-this.getQ0() / this.getQ1()};
        }

        @Override
        public Double[] stationaryPoints() {
            return new Double[0];
        }

        public static Linear fit(InputOutputPair<Double, Double> p0, InputOutputPair<Double, Double> p1) {
            double x0 = p0.getInput();
            double x1 = p1.getInput();
            double y0 = p0.getOutput();
            double y1 = p1.getOutput();
            double denom = x1 - x0;
            if (Double.isInfinite(y0)) {
                y0 = Math.signum(y0) * Double.MAX_VALUE / 10.0;
            }
            if (Double.isInfinite(y1)) {
                y1 = Math.signum(y1) * Double.MAX_VALUE / 10.0;
            }
            if (Math.abs(denom) <= 0.0) {
                throw new IllegalArgumentException("Linear interpolation points are effectively collinear: " + denom);
            }
            double q1 = (y1 - y0) / denom;
            double q0 = y0 - q1 * x0;
            return new Linear(q0, q1);
        }

        public static Linear fit(InputOutputSlopeTriplet p0) {
            double x0 = (Double)p0.getInput();
            double y0 = (Double)p0.getOutput();
            double q1 = p0.getSlope();
            double q0 = y0 - q1 * x0;
            return new Linear(q0, q1);
        }

        public double getQ0() {
            return this.q0;
        }

        public void setQ0(double q0) {
            this.q0 = q0;
        }

        public double getQ1() {
            return this.q1;
        }

        public void setQ1(double q1) {
            this.q1 = q1;
        }

        public String toString() {
            return "f(x) = " + this.getQ0() + " + " + this.getQ1() + "x";
        }
    }

    public static interface ClosedForm
    extends DifferentiableUnivariateScalarFunction {
        public Double[] roots();

        public Double[] stationaryPoints();
    }
}

