/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.scalar;

import gov.sandia.cognition.math.AbstractUnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.Vectorizable;

public class ThresholdFunction
extends AbstractUnivariateScalarFunction
implements Vectorizable {
    public static final double DEFAULT_THRESHOLD = 0.0;
    public static final double DEFAULT_LOW_VALUE = -1.0;
    public static final double DEFAULT_HIGH_VALUE = 1.0;
    private double highValue;
    private double lowValue;
    private double threshold;

    public ThresholdFunction() {
        this(0.0);
    }

    public ThresholdFunction(double threshold) {
        this(threshold, -1.0, 1.0);
    }

    public ThresholdFunction(double threshold, double lowValue, double highValue) {
        this.setThreshold(threshold);
        this.setLowValue(lowValue);
        this.setHighValue(highValue);
    }

    @Override
    public ThresholdFunction clone() {
        return (ThresholdFunction)super.clone();
    }

    @Override
    public double evaluate(double input) {
        return input >= this.getThreshold() ? this.getHighValue() : this.getLowValue();
    }

    @Override
    public Vector convertToVector() {
        Vector parameters = VectorFactory.getDefault().createVector(1);
        parameters.setElement(0, this.getThreshold());
        return parameters;
    }

    @Override
    public void convertFromVector(Vector parameters) {
        this.setThreshold(parameters.getElement(0));
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public double getHighValue() {
        return this.highValue;
    }

    public void setHighValue(double highValue) {
        this.highValue = highValue;
    }

    public double getLowValue() {
        return this.lowValue;
    }

    public void setLowValue(double lowValue) {
        this.lowValue = lowValue;
    }
}

