/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.scalar;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;

public class VectorEntryFunction
extends AbstractCloneableSerializable
implements Evaluator<Vectorizable, Double>,
Vectorizable {
    public static final int DEFAULT_INDEX = 0;
    protected int index;

    public VectorEntryFunction() {
        this(0);
    }

    public VectorEntryFunction(int index) {
        this.setIndex(index);
    }

    @Override
    public VectorEntryFunction clone() {
        return (VectorEntryFunction)super.clone();
    }

    public boolean equals(Object other) {
        return other instanceof VectorEntryFunction && ((VectorEntryFunction)other).index == this.index;
    }

    public int hashCode() {
        return this.index;
    }

    @Override
    public Double evaluate(Vectorizable input) {
        return input.convertToVector().getElement(this.index);
    }

    @Override
    public Vector convertToVector() {
        return VectorFactory.getDefault().createVector(1, this.getIndex());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(1);
        this.setIndex((int)parameters.getElement(0));
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index must be non-negative");
        }
        this.index = index;
    }
}

