/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.scalar;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.data.DatasetUtil;
import gov.sandia.cognition.learning.data.DefaultWeightedInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-06", changesNeeded=false, comments={"Made clone() call super.clone().", "Made Learner inherit SupervisedBatchLearner", "Otherwise, class looks fine."})
public class VectorFunctionToScalarFunction<InputType>
extends AbstractCloneableSerializable
implements Evaluator<InputType, Double> {
    protected Evaluator<? super InputType, ? extends Vectorizable> vectorFunction;

    public VectorFunctionToScalarFunction() {
        this(null);
    }

    public VectorFunctionToScalarFunction(Evaluator<? super InputType, ? extends Vectorizable> vectorFunction) {
        this.setVectorFunction(vectorFunction);
    }

    @Override
    public VectorFunctionToScalarFunction<InputType> clone() {
        VectorFunctionToScalarFunction result = (VectorFunctionToScalarFunction)super.clone();
        result.vectorFunction = ObjectUtil.cloneSmart(this.vectorFunction);
        return result;
    }

    @Override
    public Double evaluate(InputType input) {
        Vectorizable output = this.vectorFunction.evaluate(input);
        return output.convertToVector().getElement(0);
    }

    public Evaluator<? super InputType, ? extends Vectorizable> getVectorFunction() {
        return this.vectorFunction;
    }

    public void setVectorFunction(Evaluator<? super InputType, ? extends Vectorizable> vectorFunction) {
        this.vectorFunction = vectorFunction;
    }

    public static class Learner<InputType>
    extends AbstractCloneableSerializable
    implements SupervisedBatchLearner<InputType, Double, VectorFunctionToScalarFunction<InputType>> {
        protected BatchLearner<Collection<? extends InputOutputPair<? extends InputType, Vector>>, ? extends Evaluator<? super InputType, ? extends Vectorizable>> vectorLearner;

        public Learner() {
            this(null);
        }

        public Learner(BatchLearner<Collection<? extends InputOutputPair<? extends InputType, Vector>>, ? extends Evaluator<? super InputType, ? extends Vectorizable>> vectorLearner) {
            this.vectorLearner = vectorLearner;
        }

        @Override
        public Learner clone() {
            Learner result = (Learner)super.clone();
            result.vectorLearner = ObjectUtil.cloneSafe(this.vectorLearner);
            return result;
        }

        @Override
        public VectorFunctionToScalarFunction<InputType> learn(Collection<? extends InputOutputPair<? extends InputType, Double>> data) {
            int count = data.size();
            ArrayList<DefaultWeightedInputOutputPair<InputType, Vector>> vectorData = new ArrayList<DefaultWeightedInputOutputPair<InputType, Vector>>(count);
            for (InputOutputPair<InputType, Double> example : data) {
                InputType input = example.getInput();
                double output = example.getOutput();
                Vector outputVector = VectorFactory.getDefault().copyValues(output);
                double weight = DatasetUtil.getWeight(example);
                vectorData.add(new DefaultWeightedInputOutputPair<InputType, Vector>(input, outputVector, weight));
            }
            Evaluator<? super InputType, ? extends Vectorizable> vectorFunction = this.vectorLearner.learn(vectorData);
            return new VectorFunctionToScalarFunction<InputType>(vectorFunction);
        }
    }
}

