/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.vector;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.math.UnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorFunction;
import gov.sandia.cognition.math.matrix.VectorInputEvaluator;
import gov.sandia.cognition.math.matrix.VectorOutputEvaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class DecoupledVectorFunction
extends AbstractCloneableSerializable
implements VectorFunction,
VectorInputEvaluator<Vector, Vector>,
VectorOutputEvaluator<Vector, Vector> {
    private Collection<? extends Evaluator<? super Double, Double>> scalarFunctions;

    public DecoupledVectorFunction(UnivariateScalarFunction ... scalarFunctions) {
        this(Arrays.asList(scalarFunctions));
    }

    public DecoupledVectorFunction(Collection<? extends Evaluator<? super Double, Double>> scalarFunctions) {
        this.setScalarFunctions(scalarFunctions);
    }

    public DecoupledVectorFunction(DecoupledVectorFunction other) {
        this(new ArrayList<Evaluator<? super Double, Double>>(other.getScalarFunctions()));
    }

    public Collection<? extends Evaluator<? super Double, Double>> getScalarFunctions() {
        return this.scalarFunctions;
    }

    public void setScalarFunctions(Collection<? extends Evaluator<? super Double, Double>> scalarFunctions) {
        if (scalarFunctions.size() < 1) {
            throw new IllegalArgumentException("Must have at least one scalar function!");
        }
        this.scalarFunctions = scalarFunctions;
    }

    public int getDimensionality() {
        return this.getScalarFunctions().size();
    }

    @Override
    public Vector evaluate(Vector input) {
        int M = input.getDimensionality();
        if (M != this.getDimensionality()) {
            throw new IllegalArgumentException("Input dimensionality doesn't equal number of scalar functions!");
        }
        Vector output = VectorFactory.getDefault().createVector(M);
        int i = 0;
        for (Evaluator<? super Double, Double> evaluator : this.getScalarFunctions()) {
            double xi = input.getElement(i);
            double yi = evaluator.evaluate((Double)xi);
            output.setElement(i, yi);
            ++i;
        }
        return output;
    }

    @Override
    public int getInputDimensionality() {
        return this.getDimensionality();
    }

    @Override
    public int getOutputDimensionality() {
        return this.getDimensionality();
    }
}

