/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.vector;

import gov.sandia.cognition.learning.function.scalar.LinearFunction;
import gov.sandia.cognition.math.UnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

public class ElementWiseVectorFunction
extends AbstractCloneableSerializable
implements VectorFunction {
    private UnivariateScalarFunction scalarFunction;

    public ElementWiseVectorFunction() {
        this(new LinearFunction());
    }

    public ElementWiseVectorFunction(UnivariateScalarFunction scalarFunction) {
        this.setScalarFunction(scalarFunction);
    }

    public ElementWiseVectorFunction(ElementWiseVectorFunction other) {
        this((UnivariateScalarFunction)other.getScalarFunction().clone());
    }

    @Override
    public ElementWiseVectorFunction clone() {
        ElementWiseVectorFunction clone = (ElementWiseVectorFunction)super.clone();
        clone.setScalarFunction(ObjectUtil.cloneSafe(this.getScalarFunction()));
        return clone;
    }

    public UnivariateScalarFunction getScalarFunction() {
        return this.scalarFunction;
    }

    public void setScalarFunction(UnivariateScalarFunction scalarFunction) {
        this.scalarFunction = scalarFunction;
    }

    @Override
    public Vector evaluate(Vector input) {
        return ElementWiseVectorFunction.evaluate(input, this.scalarFunction);
    }

    public static Vector evaluate(Vector input, UnivariateScalarFunction function) {
        int M = input.getDimensionality();
        double[] outputs = new double[M];
        for (int i = 0; i < M; ++i) {
            outputs[i] = function.evaluate(input.getElement(i));
        }
        return VectorFactory.getDefault().copyArray(outputs);
    }
}

