/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.vector;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.ArrayList;

public class EntropyEvaluator
extends AbstractCloneableSerializable
implements Evaluator<Vector, Double> {
    public static final double TOLERANCE = 1.0E-5;

    @Override
    public Double evaluate(Vector input) {
        double sum = 0.0;
        int num = input.getDimensionality();
        ArrayList<Double> values = new ArrayList<Double>(num);
        for (int i = 0; i < num; ++i) {
            double v = input.getElement(i);
            sum += v;
            values.add(v);
        }
        if (Math.abs(sum - 1.0) > 1.0E-5) {
            throw new IllegalArgumentException("input elements must sum to 1.0");
        }
        return UnivariateStatisticsUtil.computeEntropy(values);
    }
}

