/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.vector;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.function.LinearCombinationFunction;
import gov.sandia.cognition.math.RingAccumulator;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class LinearCombinationVectorFunction
extends LinearCombinationFunction<Vector, Vector>
implements VectorFunction {
    public LinearCombinationVectorFunction(VectorFunction ... basisFunctions) {
        this(Arrays.asList(basisFunctions));
    }

    public LinearCombinationVectorFunction(Collection<? extends Evaluator<? super Vector, ? extends Vector>> basisFunctions) {
        this(new ArrayList<Evaluator<? super Vector, ? extends Vector>>(basisFunctions), VectorFactory.getDefault().createVector(basisFunctions.size(), 1.0));
    }

    public LinearCombinationVectorFunction(ArrayList<? extends Evaluator<? super Vector, ? extends Vector>> basisFunctions, Vector coefficients) {
        super(basisFunctions, coefficients);
    }

    @Override
    public LinearCombinationVectorFunction clone() {
        return (LinearCombinationVectorFunction)super.clone();
    }

    @Override
    public Vector evaluate(Vector input) {
        int num = this.getBasisFunctions().size();
        RingAccumulator y = new RingAccumulator();
        for (int n = 0; n < num; ++n) {
            double weight = this.getCoefficients().getElement(n);
            if (weight == 0.0) continue;
            y.accumulate(((Vector)this.getBasisFunctions().get(n).evaluate(input)).scale(weight));
        }
        return (Vector)y.getSum();
    }
}

