/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.vector;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.math.matrix.DifferentiableVectorFunction;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.util.AbstractCloneableSerializable;

@CodeReview(reviewer={"Justin Basilico"}, date="2006-10-05", changesNeeded=false, comments={"Class looks fine."})
public class LinearVectorFunction
extends AbstractCloneableSerializable
implements DifferentiableVectorFunction {
    public static final double DEFAULT_SCALE_FACTOR = 1.0;
    private double scaleFactor;

    public LinearVectorFunction() {
        this(1.0);
    }

    public LinearVectorFunction(double scaleFactor) {
        this.setScaleFactor(scaleFactor);
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    @Override
    public Vector evaluate(Vector input) {
        return (Vector)input.scale(this.getScaleFactor());
    }

    @Override
    public Matrix differentiate(Vector input) {
        int M = input.getDimensionality();
        Matrix dydx = (Matrix)MatrixFactory.getDefault().createIdentity(M, M).scale(this.getScaleFactor());
        return dydx;
    }
}

