/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.vector;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorOutputEvaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.ArrayList;
import java.util.Collection;

public class ScalarBasisSet<InputType>
extends AbstractCloneableSerializable
implements Evaluator<InputType, Vector>,
VectorOutputEvaluator<InputType, Vector> {
    private Collection<? extends Evaluator<? super InputType, Double>> basisFunctions;

    public ScalarBasisSet(Collection<? extends Evaluator<? super InputType, Double>> basisFunctions) {
        this.setBasisFunctions(basisFunctions);
    }

    public ScalarBasisSet(ScalarBasisSet<InputType> other) {
        this(new ArrayList<Evaluator<InputType, Double>>(other.getBasisFunctions()));
    }

    @Override
    public int getOutputDimensionality() {
        return this.getBasisFunctions().size();
    }

    @Override
    public Vector evaluate(InputType input) {
        Vector output = VectorFactory.getDefault().createVector(this.getOutputDimensionality());
        int i = 0;
        for (Evaluator<InputType, Double> f : this.getBasisFunctions()) {
            output.setElement(i, f.evaluate(input));
            ++i;
        }
        return output;
    }

    public Collection<? extends Evaluator<? super InputType, Double>> getBasisFunctions() {
        return this.basisFunctions;
    }

    public void setBasisFunctions(Collection<? extends Evaluator<? super InputType, Double>> basisFunctions) {
        this.basisFunctions = basisFunctions;
    }
}

