/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.vector;

import gov.sandia.cognition.math.matrix.DefaultVectorFactoryContainer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorInputEvaluator;
import gov.sandia.cognition.math.matrix.VectorOutputEvaluator;
import gov.sandia.cognition.math.matrix.Vectorizable;

public class SubVectorEvaluator
extends DefaultVectorFactoryContainer
implements VectorInputEvaluator<Vectorizable, Vector>,
VectorOutputEvaluator<Vectorizable, Vector> {
    protected int inputDimensionality;
    protected int[] subIndices;

    public SubVectorEvaluator() {
        this(-1, null);
    }

    public SubVectorEvaluator(int inputDimensionality, int[] subIndices) {
        this(inputDimensionality, subIndices, VectorFactory.getDefault());
    }

    public SubVectorEvaluator(int inputDimensionality, int[] subIndices, VectorFactory<? extends Vector> vectorFactory) {
        super(vectorFactory);
        this.setInputDimensionality(inputDimensionality);
        this.setSubIndices(subIndices);
    }

    @Override
    public Vector evaluate(Vectorizable input) {
        if (input == null) {
            return null;
        }
        Vector vector = input.convertToVector();
        if (vector == null) {
            return null;
        }
        vector.assertDimensionalityEquals(this.inputDimensionality);
        int subDimensionality = this.subIndices.length;
        Vector subVector = this.getVectorFactory().createVector(subDimensionality);
        for (int i = 0; i < subDimensionality; ++i) {
            subVector.setElement(i, vector.getElement(this.subIndices[i]));
        }
        return subVector;
    }

    @Override
    public int getInputDimensionality() {
        return this.inputDimensionality;
    }

    public void setInputDimensionality(int inputDimensionality) {
        this.inputDimensionality = inputDimensionality;
    }

    @Override
    public int getOutputDimensionality() {
        return this.subIndices.length;
    }

    public int[] getSubIndices() {
        return this.subIndices;
    }

    public void setSubIndices(int[] subIndices) {
        this.subIndices = subIndices;
    }
}

