/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.performance;

import gov.sandia.cognition.learning.data.TargetEstimatePair;
import gov.sandia.cognition.learning.performance.AbstractSupervisedPerformanceEvaluator;
import java.util.Collection;

public class RootMeanSquaredErrorEvaluator<InputType>
extends AbstractSupervisedPerformanceEvaluator<InputType, Double, Double, Double> {
    @Override
    public Double evaluatePerformance(Collection<? extends TargetEstimatePair<Double, Double>> data) {
        return RootMeanSquaredErrorEvaluator.compute(data);
    }

    public static double compute(Collection<? extends TargetEstimatePair<Double, Double>> data) {
        int count = data.size();
        if (count <= 0) {
            return 0.0;
        }
        double errorSum = 0.0;
        for (TargetEstimatePair<Double, Double> targetEstimatePair : data) {
            double target = targetEstimatePair.getTarget();
            double estimate = targetEstimatePair.getEstimate();
            double difference = target - estimate;
            double error = difference * difference;
            errorSum += error;
        }
        return Math.sqrt(errorSum / (double)count);
    }
}

