/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.performance.categorization;

import gov.sandia.cognition.factory.DefaultFactory;
import gov.sandia.cognition.factory.Factory;
import gov.sandia.cognition.learning.data.TargetEstimatePair;
import gov.sandia.cognition.learning.performance.AbstractSupervisedPerformanceEvaluator;
import gov.sandia.cognition.learning.performance.categorization.ConfusionMatrix;
import gov.sandia.cognition.learning.performance.categorization.DefaultConfusionMatrix;
import java.util.Collection;

public class ConfusionMatrixPerformanceEvaluator<InputType, CategoryType>
extends AbstractSupervisedPerformanceEvaluator<InputType, CategoryType, CategoryType, ConfusionMatrix<CategoryType>> {
    protected Factory<? extends ConfusionMatrix<CategoryType>> factory;

    public ConfusionMatrixPerformanceEvaluator() {
        this(new DefaultFactory<DefaultConfusionMatrix>(DefaultConfusionMatrix.class));
    }

    public ConfusionMatrixPerformanceEvaluator(Factory<? extends ConfusionMatrix<CategoryType>> factory) {
        this.setFactory(factory);
    }

    @Override
    public ConfusionMatrix<CategoryType> evaluatePerformance(Collection<? extends TargetEstimatePair<CategoryType, CategoryType>> data) {
        ConfusionMatrix<CategoryType> result = this.getFactory().create();
        for (TargetEstimatePair<CategoryType, CategoryType> pair : data) {
            result.add(pair.getTarget(), pair.getEstimate());
        }
        return result;
    }

    public Factory<? extends ConfusionMatrix<CategoryType>> getFactory() {
        return this.factory;
    }

    public void setFactory(Factory<? extends ConfusionMatrix<CategoryType>> factory) {
        this.factory = factory;
    }
}

